'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _cell = require('./cell');

var _cell2 = _interopRequireDefault(_cell);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _columnVisibility = require('./column-visibility');

var _columnVisibility2 = _interopRequireDefault(_columnVisibility);

var _compare = require('../../utils/compare');

var _filterDialog = require('./filter-dialog');

var _filterDialog2 = _interopRequireDefault(_filterDialog);

var _itemDialog = require('./item-dialog');

var _itemDialog2 = _interopRequireDefault(_itemDialog);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

var _lodash = require('lodash');

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var Table = function (_React$Component) {
  _inherits(Table, _React$Component);

  function Table(props) {
    _classCallCheck(this, Table);

    var _this = _possibleConstructorReturn(this, (Table.__proto__ || Object.getPrototypeOf(Table)).call(this, props));

    _this.componentWillReceiveProps = function (nextProps) {
      if (!(0, _lodash.isEqual)(nextProps.headers, _this.props.headers)) {
        var valueMap = _this.generateValueMap(nextProps.headers);
        _this.setState({ valueMap: valueMap });
      }
    };

    _this.generateValueMap = function (headers) {
      return headers.reduce(function (map, header) {
        var options = (0, _lodash.get)(header, ['template', 'details', 'options'], []);
        if (!(0, _lodash.isEmpty)(options)) {
          map[header.key] = options.reduce(function (acc, option) {
            acc[option.key] = option.lbl;
            return acc;
          }, {});
        }
        return map;
      }, {});
    };

    _this.mappedGadgetValue = function (formKey, value) {
      var valueMap = _this.state.valueMap;

      return (0, _lodash.get)(valueMap, [formKey, value], value);
    };

    _this.filterHeaders = function (headers, hiddenColumns) {
      return headers.filter(function (header) {
        return !(0, _lodash.includes)(hiddenColumns, header.key);
      });
    };

    _this.createRowControl = function (name, handler, row, disabled) {
      return _react2.default.createElement(
        'div',
        { className: _style2.default.rowControlsCell, style: { flex: '0 0 50px' } },
        _react2.default.createElement(
          _kualiUi.IconButton,
          {
            'data-test': name,
            onClick: function onClick() {
              return handler(row);
            },
            disabled: disabled
          },
          _react2.default.createElement(_kualiUi.Icon, { name: name })
        )
      );
    };

    _this.handleSort = function (headerKey) {
      var _this$state = _this.state,
          sortCol = _this$state.sortCol,
          sortAsc = _this$state.sortAsc;

      // Clicking on the same header repeatedly toggles through asc, desc, and unsort.

      var clickedHeaderOnce = sortCol === headerKey;
      var clickedHeaderTwice = clickedHeaderOnce && !sortAsc;

      if (clickedHeaderTwice) {
        _this.resetSort();
      } else {
        _this.setState({
          sortCol: headerKey,
          sortAsc: !clickedHeaderOnce
        });
      }
    };

    _this.resetSort = function () {
      _this.setState({
        sortAsc: true,
        sortCol: null
      });
    };

    _this.handleAddRowClicked = function () {
      var rows = _this.props.rows;

      if (_this.isDialog) {
        _this.setState({
          dialogItemEditable: true,
          showItemDialog: true,
          dialogItem: null,
          dialogItemIndex: rows.length
        });
      } else {
        _this.resetSort();
        _this.addNewRow();
      }
    };

    _this.addNewRow = function () {
      var _this$props = _this.props,
          createNewRow = _this$props.createNewRow,
          onChange = _this$props.onChange,
          rows = _this$props.rows;

      var newListRows = (0, _lodash.cloneDeep)(rows);
      var newLine = createNewRow();
      newListRows.push(newLine);
      onChange(newListRows);
    };

    _this.handleShowColumnVisibility = function (evt) {
      _this.setState({
        showColumnVisibility: !_this.state.showColumnVisibility
      });
      evt.stopPropagation();
    };

    _this.handleHideColumnVisibility = function (evt) {
      _this.setState({ showColumnVisibility: false });
    };

    _this.handleColumnVisibilityChange = function (hiddenColumns) {
      _this.setState({ hiddenColumns: hiddenColumns });
      _this.props.onColumnVisibilityChange(hiddenColumns);
    };

    _this.handleRowKeyPress = function (rowIndex, e) {
      // Add new row on shift + return when on last row
      if (e.shiftKey && e.which === 13 && rowIndex === _this.props.rows.length - 1) {
        _this.handleAddRowClicked();
      }
    };

    _this.handleFilterClicked = function (colKey, e) {
      e.stopPropagation(); // Prevent column from being sorted
      if (_this.filterPopoverClosed) {
        // Debounce
        return;
      }
      // Toggle which column should display the filter dialog
      _this.setState(function (prevState) {
        return {
          filterDialogCol: prevState.filterDialogCol === colKey ? null : colKey
        };
      });
    };

    _this.handleFilterPopoverClosed = function () {
      _this.setState({
        filterDialogCol: null
      });

      // Set flag used to debounce
      _this.filterPopoverClosed = true;
      setTimeout(function () {
        _this.filterPopoverClosed = false;
      }, 100);
    };

    _this.handleViewEditItem = function (readOnly, row) {
      _this.setState({
        dialogItemReadOnly: readOnly,
        dialogItemIndex: row.index,
        dialogItem: (0, _lodash.cloneDeep)(row),
        showItemDialog: true
      });
    };

    _this.handleRemoveRow = function (row) {
      var _this$props2 = _this.props,
          onChange = _this$props2.onChange,
          rows = _this$props2.rows;

      var newListRows = (0, _lodash.cloneDeep)(rows);
      newListRows.splice(row.index, 1);
      onChange(newListRows);
    };

    _this.handleItemDialogClose = function () {
      _this.setState({
        dialogItem: null,
        showItemDialog: false
      });
    };

    _this.handleOnChange = function (item) {
      var dialogItemIndex = _this.state.dialogItemIndex;
      var _this$props3 = _this.props,
          onChange = _this$props3.onChange,
          rows = _this$props3.rows;

      var newRows = (0, _lodash.set)(rows, dialogItemIndex, item.id ? item : _this.props.addId(item));
      onChange(newRows);
    };

    _this.handleItemDialogSave = function (item) {
      _this.handleOnChange(item);
      _this.setState({
        dialogItem: null,
        dialogItemIndex: -1,
        showItemDialog: false
      });
    };

    _this.handleGadgetChange = function (rowIndex, formKey, newValue) {
      var _this$props4 = _this.props,
          rows = _this$props4.rows,
          onChange = _this$props4.onChange;

      var newListRows = (0, _lodash.cloneDeep)(rows);
      (0, _lodash.set)(newListRows, [rowIndex, formKey], newValue);
      onChange(newListRows);
    };

    _this.createRow = function (row, renderIndex, showControls, additionalContext, readOnly) {
      var _this$props5 = _this.props,
          headers = _this$props5.headers,
          template = _this$props5.template,
          mode = _this$props5.mode,
          renderRow = _this$props5.renderRow;
      var hiddenColumns = _this.state.hiddenColumns;

      var rowIndex = row.index;
      var gadgetMode = _this.isDialog ? 'view' : mode;
      var columns = _this.filterHeaders(headers, hiddenColumns);
      if (showControls === undefined || showControls === null) {
        showControls = mode === 'edit';
      }
      if (readOnly === undefined || readOnly === null) {
        readOnly = mode === 'view';
      }

      // Never show a label from within a row
      var childTemplates = columns.map(function (column, index) {
        var template = (0, _lodash.cloneDeep)(column.template);
        template.id = column.key + '-' + rowIndex;
        return (0, _lodash.omit)(template, ['label', 'desc', 'question', 'progressiveDisclosure']);
      });

      var newRow = renderRow(gadgetMode, childTemplates, row, (0, _lodash.partial)(_this.handleGadgetChange, rowIndex), rowIndex, additionalContext);

      newRow = _react2.default.Children.map(newRow, function (child) {
        return _react2.default.createElement(
          _cell2.default,
          { id: (0, _lodash.get)(child, ['key']) },
          child
        );
      });

      var showViewEditControl = _this.isDialog && (showControls || mode === 'view');
      var buttonViewMode = mode === 'view' || readOnly;
      var viewEditIcon = buttonViewMode ? 'remove_red_eye' : 'create';

      var key = template.id + '-' + row.id;
      return (
        // Pass down the original index in case we need to map from original rows to sorted rows later
        _react2.default.createElement(
          'div',
          {
            className: _style2.default.row,
            'data-index': row.index,
            key: key,
            onKeyPress: (0, _lodash.partial)(_this.handleRowKeyPress, renderIndex)
          },
          newRow,
          showViewEditControl && _this.createRowControl(viewEditIcon, (0, _lodash.partial)(_this.handleViewEditItem, readOnly), row, false),
          showControls && _this.createRowControl('delete', _this.handleRemoveRow, row, readOnly)
        )
      );
    };

    _this.transformChildRows = function (showControls) {
      var rows = _this.props.rows;
      var _this$state2 = _this.state,
          sortCol = _this$state2.sortCol,
          sortAsc = _this$state2.sortAsc,
          filterValues = _this$state2.filterValues;

      // Keep track of original index

      var renderRows = rows.map(function (row, index) {
        return _extends({}, row, { index: index });
      });

      // Filter rows
      if (!(0, _lodash.isEmpty)(filterValues)) {
        renderRows = renderRows.filter(function (row) {
          var filterCols = (0, _lodash.intersection)((0, _lodash.keys)(row), (0, _lodash.keys)(filterValues));
          for (var i = 0; i < filterCols.length; i++) {
            var col = filterCols[i];
            if ((0, _lodash.includes)(filterValues[col], row[col])) {
              return false; // This value has been hidden
            }
          }
          return true;
        });
      }

      // Sort rows if necessary
      if (sortCol) {
        renderRows.sort(function (a, b) {
          a = a[sortCol];
          b = b[sortCol];

          a = _this.mappedGadgetValue(sortCol, a);
          b = _this.mappedGadgetValue(sortCol, b);
          return (0, _compare.compare)(a, b, sortAsc);
        });
      }

      return renderRows.map(function (row, idx) {
        return _this.createRow(row, idx, showControls);
      });
    };

    _this.updateFilterValuesForCol = function (colKey, values) {
      _this.setState(function (prevState) {
        return {
          filterValues: _extends({}, prevState.filterValues, _defineProperty({}, colKey, values))
        };
      });
    };

    _this.headerControl = function (header, rows, sortOpts, filterOpts) {
      var hiddenValues = filterOpts.hiddenValues,
          showFilterDialog = filterOpts.showFilterDialog;
      var sortAsc = sortOpts.sortAsc,
          sorted = sortOpts.sorted;

      var filtersApplied = !(0, _lodash.isEmpty)(hiddenValues);
      return _react2.default.createElement(
        _kualiUi.Popover,
        {
          align: 'left',
          contentClassName: _style2.default.filterPopoverContent,
          content: _react2.default.createElement(_filterDialog2.default, {
            colKey: header.key,
            hiddenValues: hiddenValues,
            rows: rows,
            labelForValue: _this.mappedGadgetValue,
            updateHiddenValues: (0, _lodash.partial)(_this.updateFilterValuesForCol, header.key)
          }),
          hideArrow: true,
          key: header.key,
          position: 'bottom',
          onRequestClose: _this.handleFilterPopoverClosed,
          trapFocus: false,
          visible: showFilterDialog
        },
        _react2.default.createElement(
          'div',
          {
            key: header.key,
            className: _style2.default.headerColumn + ' ' + (sorted ? _style2.default.sorted : '') + ' ' + (showFilterDialog ? _style2.default.filterDialogShown : ''),
            onClick: (0, _lodash.partial)(_this.handleSort, header.key),
            onMouseDown: function onMouseDown(e) {
              return (
                /* Prevents text highlighting when clicked multiple times */
                e.preventDefault()
              );
            }
          },
          _react2.default.createElement(
            'div',
            { className: _style2.default.headerColumnLabel },
            header.label
          ),
          _react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(
              'div',
              { style: { display: 'flex' } },
              sorted && _react2.default.createElement(_kualiUi.Icon, {
                name: 'arrow_drop_' + (sortAsc ? 'up' : 'down'),
                style: { color: 'white' }
              }),
              _react2.default.createElement(_kualiUi.Icon, {
                className: _style2.default.filterButton + ' ' + (filtersApplied ? _style2.default.applied : ''),
                name: 'filter_list',
                onClick: (0, _lodash.partial)(_this.handleFilterClicked, header.key)
              })
            )
          )
        )
      );
    };

    _this.columnVisibilityControl = function (headers, hiddenColumns, showColumnVisibility) {
      return _react2.default.createElement(
        _kualiUi.Popover,
        {
          content: _react2.default.createElement(_columnVisibility2.default, {
            initialHiddenColumns: hiddenColumns,
            headers: headers,
            onChange: _this.handleColumnVisibilityChange
          }),
          onRequestClose: _this.handleHideColumnVisibility,
          position: 'bottom',
          title: 'Columns',
          trapFocus: false,
          visible: showColumnVisibility
        },
        _react2.default.createElement(
          _kualiUi.RaisedButton,
          {
            label: 'Columns',
            onMouseDown: _this.handleShowColumnVisibility
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'remove_red_eye' })
        )
      );
    };

    _this.spacerHeaderColumns = function () {
      var mode = _this.props.mode;

      var hasDeleteIcon = mode === 'edit';
      var hasEditIcon = mode === 'edit' && _this.isDialog;
      var hasViewIcon = mode === 'view' && _this.isDialog;

      var spacers = [];
      if (hasDeleteIcon) {
        spacers = _this.addSpacer(spacers, 'delete');
      }

      if (hasEditIcon) {
        spacers = _this.addSpacer(spacers, 'edit');
      }

      if (hasViewIcon) {
        spacers = _this.addSpacer(spacers, 'view');
      }
      return spacers;
    };

    _this.state = {
      dialogItem: null,
      dialogItemReadOnly: false,
      filterValues: {},
      hiddenColumns: _this.props.initialHiddenColumns,
      dialogItemIndex: -1,
      showItemDialog: false,
      showColumnVisibility: false,
      sortCol: null,
      sortAsc: true,
      valueMap: _this.generateValueMap(props.headers)
    };
    return _this;
  }

  _createClass(Table, [{
    key: 'addSpacer',
    value: function addSpacer(spacers, column) {
      return [].concat(_toConsumableArray(spacers), [_react2.default.createElement('div', {
        className: _style2.default.headerColumn + ' ' + _style2.default.rowControls,
        key: 'spacer-' + column
      })]);
    }
  }, {
    key: 'addInfo',
    value: function addInfo() {
      return _react2.default.createElement(
        'div',
        { className: (0, _classnames2.default)(_style2.default.row, _style2.default.addRow) },
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            'data-test': 'add_info',
            label: 'Add Info',
            onClick: this.handleAddRowClicked,
            variant: 'clear'
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'add' })
        )
      );
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          _props$className = _props.className,
          className = _props$className === undefined ? '' : _props$className,
          decorate = _props.decorate,
          headers = _props.headers,
          mode = _props.mode,
          rows = _props.rows,
          renderRow = _props.renderRow,
          showColumnVisibilityControl = _props.showColumnVisibilityControl,
          template = _props.template,
          headingParts = _props.headingParts;
      var _state = this.state,
          dialogItem = _state.dialogItem,
          dialogItemIndex = _state.dialogItemIndex,
          dialogItemReadOnly = _state.dialogItemReadOnly,
          filterDialogCol = _state.filterDialogCol,
          filterValues = _state.filterValues,
          hiddenColumns = _state.hiddenColumns,
          showItemDialog = _state.showItemDialog,
          showColumnVisibility = _state.showColumnVisibility,
          sortCol = _state.sortCol,
          sortAsc = _state.sortAsc;


      var showControls = mode === 'edit';

      var filteredHeaders = this.filterHeaders(headers, hiddenColumns);
      var listHeader = filteredHeaders.map(function (header, index) {
        var sorted = header.key === sortCol;
        var showFilterDialog = header.key === filterDialogCol;
        var hiddenValues = filterValues[header.key] || [];
        return _this2.headerControl(header, rows, { sorted: sorted, sortAsc: sortAsc }, { hiddenValues: hiddenValues, showFilterDialog: showFilterDialog });
      });
      listHeader = listHeader.concat(this.spacerHeaderColumns());

      var renderRows = this.transformChildRows(showControls);
      var decorated = _extends({}, decorate(headingParts), decorate({ listHeader: listHeader }), decorate({ gadgetChildren: renderRows }, this.createRow));

      var wrapperStyle = (0, _classnames2.default)(_style2.default.wrapper, className);
      var columnVisibilityControl = showColumnVisibilityControl ? this.columnVisibilityControl(headers, hiddenColumns, showColumnVisibility) : null;

      var addButton = showControls ? _react2.default.createElement(
        _kualiUi.RaisedButton,
        {
          id: 'addButton',
          label: 'Add Line',
          onClick: this.handleAddRowClicked
        },
        _react2.default.createElement(_kualiUi.Icon, { name: 'add' })
      ) : null;

      return _react2.default.createElement(
        'div',
        { className: wrapperStyle, key: template.id },
        showItemDialog && _react2.default.createElement(_itemDialog2.default, {
          readOnly: dialogItemReadOnly,
          item: dialogItem,
          itemIndex: dialogItemIndex,
          visible: showItemDialog,
          headers: headers,
          renderRow: renderRow,
          onSave: this.handleItemDialogSave,
          onChange: this.handleOnChange,
          onClose: this.handleItemDialogClose
        }),
        _react2.default.createElement(
          'div',
          { className: _style2.default.row, style: { alignItems: 'flex-end' } },
          _react2.default.createElement(
            'div',
            null,
            _react2.default.createElement(
              'div',
              { className: _style2.default.title },
              decorated.label,
              decorated.question,
              decorated.desc
            )
          ),
          _react2.default.createElement(
            'div',
            { className: _style2.default.controls },
            columnVisibilityControl,
            addButton
          )
        ),
        _react2.default.createElement(
          'div',
          { className: _style2.default.row },
          decorated.listHeader
        ),
        (0, _lodash.isEmpty)(decorated.gadgetChildren) && showControls ? this.addInfo() : decorated.gadgetChildren
      );
    }
  }, {
    key: 'isDialog',
    get: function get() {
      return this.props.listType === 'dialog';
    }

    // React lifecycle


    // Helpers


    // Sorting


    // Event Handlers


    // Row control handlers


    // Dialog Handlers

  }]);

  return Table;
}(_react2.default.Component);

Table.propTypes = {
  className: _propTypes2.default.string,
  columns: _propTypes2.default.array,
  addId: _propTypes2.default.func.isRequired,
  decorate: _propTypes2.default.func,
  formbotOptions: _propTypes2.default.object,
  headers: _propTypes2.default.array.isRequired,
  initialHiddenColumns: _propTypes2.default.array,
  listType: _propTypes2.default.string,
  mode: _propTypes2.default.string,
  onChange: _propTypes2.default.func,
  onColumnVisibilityChange: _propTypes2.default.func,
  rows: _propTypes2.default.array,
  renderRow: _propTypes2.default.func,
  showColumnVisibilityControl: _propTypes2.default.bool,
  template: _propTypes2.default.object
};
Table.defaultProps = {
  initialHiddenColumns: [],
  listType: 'inline',
  onColumnVisibilityChange: _lodash.noop,
  showColumnVisibilityControl: true
};
exports.default = Table;