'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

var _forms = require('@kuali/kuali-ui/lib/forms');

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactMd = require('react-md');

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ToggleConfig(_ref) {
  var _onChange = _ref.onChange,
      value = _ref.value;

  return _react2.default.createElement(
    'div',
    null,
    _react2.default.createElement(
      'h3',
      null,
      'Settings'
    ),
    _react2.default.createElement(
      _kualiUi.Form,
      { showGrid: true },
      _react2.default.createElement(
        _kualiUi.FieldGroup,
        null,
        _react2.default.createElement(
          _forms.FieldCell,
          null,
          _react2.default.createElement(
            _kualiUi.Label,
            { htmlFor: 'defaultValue' },
            'Default Value'
          ),
          _react2.default.createElement(_reactMd.SelectionControl, {
            'aria-label': 'Default Value',
            id: 'defaultValue',
            name: 'defaultValue',
            type: 'switch',
            checked: value.defaultValue,
            onChange: function onChange(checked) {
              return _onChange(_extends({}, value, { defaultValue: checked }));
            }
          })
        )
      )
    )
  );
}

exports.default = ToggleConfig;
ToggleConfig.displayName = 'ToggleConfig';

ToggleConfig.propTypes = {
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.shape({
    defaultValue: _propTypes2.default.bool
  }).isRequired
};