#!/usr/bin/env node

const minimist = require('minimist')
const updateNotifier = require('update-notifier')

const help = require('./help')
const { check, license } = require('./license')
const version = require('./version')
const pkg = require('../package')

/* istanbul ignore if */
if (pkg.dist) {
  updateNotifier({ pkg }).notify()
}

const aliases = new Map([
  ['c', 'check'],
  ['h', 'help'],
  ['l', 'license'],
  ['v', 'version']
])

const argv = minimist(process.argv.slice(2), {
  boolean: ['help', 'version', 'agpl', 'private'],
  string: ['years'],
  alias: {
    help: 'h',
    version: 'v',
    agpl: 'a',
    private: 'p',
    years: 'y'
  }
})

let cmd = argv._[0]
cmd = aliases.get(cmd) || cmd

if (cmd === 'help') {
  help()
} else if (cmd === 'version') {
  version()
} else if (argv.help) {
  help()
} else if (argv.version) {
  version()
} else if (cmd === 'check') {
  check(argv.years || '2016', whichCopyrightFile(argv)).catch(e => {
    console.error(e.message)
    process.exit(1)
  })
} else if (cmd === 'license') {
  license(argv.years || '2016', whichCopyrightFile(argv))
} else {
  help()
}

function whichCopyrightFile (argv) {
  if (argv.agpl) {
    return 'agpl-copyright.txt'
  } else if (argv.private) {
    return 'private-copyright.txt'
  } else {
    return 'prerelease-copyright-notice.txt'
  }
}
