'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _isRequiredForA11y = require('react-prop-types/lib/isRequiredForA11y');

var _isRequiredForA11y2 = _interopRequireDefault(_isRequiredForA11y);

var _Menu = require('../Menus/Menu');

var _Menu2 = _interopRequireDefault(_Menu);

var _AccessibleFakeInkedButton = require('../Helpers/AccessibleFakeInkedButton');

var _AccessibleFakeInkedButton2 = _interopRequireDefault(_AccessibleFakeInkedButton);

var _mapToListParts = require('../utils/mapToListParts');

var _mapToListParts2 = _interopRequireDefault(_mapToListParts);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

/**
 * The `MenuTab` component is used when there are too many desktop tabs
 * to be displayed without any overflow. If the `Tabs` component is used,
 * this will automatically be included when the `menuOverflow` prop is true.
 */
var MenuTab = function (_PureComponent) {
  _inherits(MenuTab, _PureComponent);

  function MenuTab() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, MenuTab);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = MenuTab.__proto__ || Object.getPrototypeOf(MenuTab)).call.apply(_ref, [this].concat(args))), _this), _this.state = { visible: false }, _this._toggleVisible = function (e) {
      if (_this.props.onClick) {
        _this.props.onClick(e);
      }

      _this.setState({ visible: !_this.state.visible });
    }, _this._handleClose = function () {
      _this.setState({ visible: false });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(MenuTab, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          id = _props.id,
          style = _props.style,
          className = _props.className,
          tabStyle = _props.tabStyle,
          tabClassName = _props.tabClassName,
          tabs = _props.tabs,
          label = _props.label,
          activeTabIndex = _props.activeTabIndex,
          overflowAtIndex = _props.overflowAtIndex,
          props = _objectWithoutProperties(_props, ['id', 'style', 'className', 'tabStyle', 'tabClassName', 'tabs', 'label', 'activeTabIndex', 'overflowAtIndex']);

      var active = activeTabIndex >= overflowAtIndex;

      var tab = _react2.default.createElement(
        _AccessibleFakeInkedButton2.default,
        _extends({}, props, {
          onClick: this._toggleVisible,
          style: tabStyle,
          className: (0, _classnames2.default)('md-tab md-tab--menu', tabClassName)
        }),
        label
      );

      return _react2.default.createElement(
        _Menu2.default,
        {
          id: id,
          style: style,
          className: (0, _classnames2.default)('md-menu--tab', {
            'md-tab--active': active,
            'md-tab--inactive': !active
          }, className),
          toggle: tab,
          visible: this.state.visible,
          onClose: this._handleClose
        },
        tabs.map(_mapToListParts2.default)
      );
    }
  }]);

  return MenuTab;
}(_react.PureComponent);

MenuTab.propTypes = {
  /**
   * An id to give the tab's menu.
   */
  id: (0, _isRequiredForA11y2.default)(_propTypes2.default.oneOfType([_propTypes2.default.number, _propTypes2.default.string])),

  /**
   * The current active tab index. This is used to determine which list item
   * is active in the menu, and if the styles for an active tab should be applied
   * to the menu.
   */
  activeTabIndex: _propTypes2.default.number.isRequired,

  /**
   * An tab index that caused the overflow to happen.
   */
  overflowAtIndex: _propTypes2.default.number.isRequired,

  /**
   * A list of tabs that should be rendered in the menu once opened. This can either
   * be:
   *
   * - a `ListItem`, `Divider`, or `Subheader` component
   * - a string to use as the `primaryText` for a list item
   * - an object that defines props to generate a `ListItem`, `Divider`, or `Subheader` component
   */
  tabs: _propTypes2.default.arrayOf(_propTypes2.default.oneOfType([_propTypes2.default.element, _propTypes2.default.string, _propTypes2.default.shape({
    divider: _propTypes2.default.bool,
    subheader: _propTypes2.default.bool,
    primaryText: _propTypes2.default.node
  })])).isRequired,

  /**
   * An optional style to apply to the menu.
   */
  style: _propTypes2.default.object,

  /**
   * An optional className to apply to the menu.
   */
  className: _propTypes2.default.string,

  /**
   * An optional style to apply to the tab in the menu.
   */
  tabStyle: _propTypes2.default.object,

  /**
   * An optional className to apply to the tab in the menu.
   */
  tabClassName: _propTypes2.default.string,

  /**
   * An optional function to call when the tab is clicked.
   */
  onClick: _propTypes2.default.func,

  /**
   * The label to display in the tab. This should normally be some text with
   * a drop down arrow next to it.
   */
  label: _propTypes2.default.node.isRequired
};
exports.default = MenuTab;
//# sourceMappingURL=MenuTab.js.map