"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getDayOfWeek;
/** @module utils/DateUtils/getDayOfWeek */

/**
 * Gets a day in the week. 0 = Sunday 6 = Saturday
 *
 * @param {date} sourceDate the date to find a relative day of week from
 * @param {number} dow the day of the week to find
 * @return a new Date as the given day of week
 */
function getDayOfWeek(sourceDate) {
  var dow = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

  var date = new Date(sourceDate);
  var day = date.getDay();

  var diff = date.getDate() - day + dow;
  return new Date(date.setDate(diff));
}
//# sourceMappingURL=getDayOfWeek.js.map