"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = getLastDay;
/** @module utils/DateUtils/getLastDay */

/**
 * Gets the last day in a month
 *
 * @param {Date} sourceDate the date to get the last day from.
 * @return a new Date as the last day of the month.
 */
function getLastDay(sourceDate) {
  return new Date(sourceDate.getFullYear(), sourceDate.getMonth() + 1, 0);
}
//# sourceMappingURL=getLastDay.js.map