"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = stripTime;
/** @module utils/DateUtils/stripTime */

/**
 * Removes all time from a date. Only keeps year, month, and date.
 * @param {Date} date the date to strip
 * @return a new Date with the time stripped.
 */
function stripTime(date) {
  if (!date || !(date instanceof Date)) {
    return null;
  }

  return new Date(date.getFullYear(), date.getMonth(), date.getDate());
}
//# sourceMappingURL=stripTime.js.map