'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

exports.structure = structure;
exports.render = render;
exports.onChange = onChange;
exports.configOnChange = configOnChange;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function structure(Gadget, struct) {
  it('should have a certain structure', function () {
    expect(Gadget).toMatchObject(struct);
  });
}

function render(Gadget, renderProps) {
  describe('Gadget Render', function () {
    it('should render a view component', function () {
      var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(Gadget.view, renderProps.view));
      expect(wrapper).toMatchSnapshot();
    });

    describe('Edit', function () {
      it('should render an edit component', function () {
        var editProps = _extends({
          onChange: jest.fn()
        }, renderProps.edit);
        var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(Gadget.edit, editProps));
        expect(wrapper).toMatchSnapshot();
      });
    });

    if (renderProps.progDisc) {
      describe('Progressive Disclosure', function () {
        var Disclosure = Gadget.progressiveDisclosure;
        it('should render a progressive disclosure component', function () {
          var progProps = _extends({
            onChange: jest.fn()
          }, renderProps.progDisc);
          var wrapper = (0, _enzyme.mount)(_react2.default.createElement(Disclosure.component, progProps));
          expect(wrapper).toMatchSnapshot();
        });
      });
    }

    if (renderProps.config) {
      describe('Config', function () {
        it('should render an edit component', function () {
          var configProps = _extends({
            onChange: jest.fn()
          }, renderProps.config);
          var wrapper = (0, _enzyme.shallow)(_react2.default.createElement(Gadget.config, configProps));
          expect(wrapper).toMatchSnapshot();
        });
      });
    }
  });
}

function onChange(GadgetComponent, renderProps, selector, params) {
  it('should call onChange if the field changes', function () {
    var props = _extends({
      onChange: jest.fn()
    }, renderProps);
    var wrapper = (0, _enzyme.mount)(_react2.default.createElement(GadgetComponent, props));
    wrapper.find(selector).simulate('change', params.change);
    expect(props.onChange).toHaveBeenCalledWith(params.check);
  });
}

function configOnChange(Gadget, props) {
  var selector = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'input';

  describe('Config onChange', function () {
    onChange(Gadget.config, props.config, selector, {
      change: {
        target: { value: 'abc' }
      },
      check: {
        placeholder: 'abc'
      }
    });
  });
}