'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _lodash = require('lodash');

var _gadgetButton = require('../gadget-button');

var _gadgetButton2 = _interopRequireDefault(_gadgetButton);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var AddItem = function (_Component) {
  _inherits(AddItem, _Component);

  function AddItem() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, AddItem);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = AddItem.__proto__ || Object.getPrototypeOf(AddItem)).call.apply(_ref, [this].concat(args))), _this), _this.state = {
      visible: false
    }, _this.handleToggleVisibility = function (e) {
      _this.setState({ visible: !_this.state.visible });
    }, _this.handleRequestClose = function (e) {
      _this.setState({ visible: false });
    }, _this.handleGadgetButtonClick = function (gadget) {
      _this.props.onGadgetSelection(gadget);
      _this.setState({ visible: false });
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(AddItem, [{
    key: 'gadgetList',
    value: function gadgetList() {
      var _this2 = this;

      var flatGadgets = (0, _lodash.flatMap)(this.props.gadgets, function (gadget, type) {
        return _extends({}, gadget, {
          type: type
        });
      });
      var filteredGadgets = (0, _lodash.reject)(flatGadgets, 'meta.hidden');
      var gadgetGroups = (0, _lodash.groupBy)(filteredGadgets, 'meta.category');
      return (0, _lodash.map)(gadgetGroups, function (gadgets, groupName) {
        var gadgetList = (0, _lodash.map)(gadgets, function (gadget, index) {
          return _react2.default.createElement(_gadgetButton2.default, {
            key: gadget.meta.lbl,
            style: { marginLeft: 0 },
            gadget: gadget,
            onClick: _this2.handleGadgetButtonClick,
            className: _style2.default['gadget-button']
          });
        });
        return _react2.default.createElement(
          'div',
          { key: groupName, className: _style2.default['gadget-section'] },
          _react2.default.createElement(
            'h4',
            { className: _style2.default['gadget-section--header'] },
            groupName
          ),
          _react2.default.createElement(
            'div',
            { className: _style2.default['gadget-section--list'] },
            gadgetList
          ),
          _react2.default.createElement('div', { className: _style2.default['gadget-section--divider'] })
        );
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var visible = this.state.visible;

      return _react2.default.createElement(
        'div',
        { className: _style2.default['container'] },
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            label: 'Add Item',
            onClick: this.handleToggleVisibility,
            className: _style2.default['add-gadget-button']
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'add' })
        ),
        _react2.default.createElement(
          _kualiUi.Dialog,
          {
            focusOnMount: true,
            containFocus: true,
            className: _style2.default.popover,
            contentClassName: _style2.default['popover-content'],
            modal: true,
            onHide: this.handleRequestClose,
            title: 'Add Item',
            visible: visible
          },
          this.gadgetList()
        )
      );
    }
  }]);

  return AddItem;
}(_react.Component);

AddItem.propTypes = {
  gadgets: _propTypes2.default.object.isRequired,
  onGadgetSelection: _propTypes2.default.func.isRequired,
  test: _propTypes2.default.object
};
exports.default = AddItem;