'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

var _descriptorIcon = require('../descriptor-icon');

var _descriptorIcon2 = _interopRequireDefault(_descriptorIcon);

var _kualiUi = require('@kuali/kuali-ui');

var _lodash = require('lodash');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var GadgetDescriptor = function (_Component) {
  _inherits(GadgetDescriptor, _Component);

  function GadgetDescriptor() {
    _classCallCheck(this, GadgetDescriptor);

    return _possibleConstructorReturn(this, (GadgetDescriptor.__proto__ || Object.getPrototypeOf(GadgetDescriptor)).apply(this, arguments));
  }

  _createClass(GadgetDescriptor, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          gadget = _props.gadget,
          gadgets = _props.gadgets,
          className = _props.className,
          descriptorLabel = _props.descriptorLabel,
          onClickSettings = _props.onClickSettings,
          onDelete = _props.onDelete;

      var descriptorClassName = (0, _classnames2.default)(_style2.default['descriptor-container'], className);
      var type = gadgets[gadget.type];

      return _react2.default.createElement(
        'div',
        { className: descriptorClassName },
        _react2.default.createElement(
          'div',
          {
            className: (0, _classnames2.default)(_style2.default['descriptor-col1'], _style2.default['descriptor-col1-width'])
          },
          _react2.default.createElement(_descriptorIcon2.default, { name: 'menu' }),
          _react2.default.createElement(
            'span',
            null,
            (0, _lodash.get)(type, 'meta.lbl', 'Missing Label')
          )
        ),
        _react2.default.createElement(
          'div',
          {
            className: (0, _classnames2.default)(_style2.default['label-container'], _style2.default['label-container-width'])
          },
          _react2.default.createElement(
            'div',
            { className: _style2.default['column-header'] },
            descriptorLabel || _react2.default.createElement(
              'div',
              { style: { display: 'flex', flexFlow: 'row nowrap' } },
              _react2.default.createElement(
                'span',
                null,
                'Field Label'
              ),
              _react2.default.createElement(
                'span',
                { className: _style2.default['label-desc-long'] },
                '\xA0+ Description'
              )
            )
          ),
          _react2.default.createElement(
            'div',
            null,
            gadget.label
          )
        ),
        _react2.default.createElement(
          'div',
          { className: _style2.default['size-col'] },
          _react2.default.createElement(
            'div',
            {
              className: (0, _classnames2.default)(_style2.default['size-container'], _style2.default['size-container-width'])
            },
            _react2.default.createElement(
              'div',
              { className: _style2.default['column-header'] },
              'Size'
            ),
            _react2.default.createElement(
              'div',
              null,
              (0, _lodash.capitalize)(gadget.fieldSize) || 'Large'
            )
          )
        ),
        _react2.default.createElement(
          'div',
          { style: { flex: '1', justifyContent: 'flex-end', display: 'flex' } },
          _react2.default.createElement(
            _kualiUi.IconButton,
            {
              'aria-label': 'Delete ' + gadget.label + ' gadget',
              onClick: function onClick() {
                return onDelete(gadget.id);
              }
            },
            _react2.default.createElement(_descriptorIcon2.default, {
              name: 'delete',
              iconStyle: {
                padding: 0
              }
            })
          ),
          _react2.default.createElement(
            _kualiUi.IconButton,
            {
              'aria-label': 'Configure ' + gadget.label + ' gadget',
              onClick: function onClick() {
                return onClickSettings(gadget.id);
              }
            },
            _react2.default.createElement(_descriptorIcon2.default, {
              name: 'settings',
              iconStyle: {
                padding: 0
              }
            })
          )
        )
      );
    }
  }]);

  return GadgetDescriptor;
}(_react.Component);

GadgetDescriptor.propTypes = {
  gadget: _propTypes2.default.object.isRequired,
  className: _propTypes2.default.string,
  descriptorLabel: _propTypes2.default.string
};
exports.default = GadgetDescriptor;