'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _shortid = require('shortid');

var _shortid2 = _interopRequireDefault(_shortid);

var _style = require('../gadget-descriptor/style.css');

var _style2 = _interopRequireDefault(_style);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _gadgetDescriptor = require('../gadget-descriptor');

var _gadgetDescriptor2 = _interopRequireDefault(_gadgetDescriptor);

var _addItem = require('../add-item');

var _addItem2 = _interopRequireDefault(_addItem);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var SectionDescriptor = function (_Component) {
  _inherits(SectionDescriptor, _Component);

  function SectionDescriptor() {
    var _ref;

    var _temp, _this, _ret;

    _classCallCheck(this, SectionDescriptor);

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return _ret = (_temp = (_this = _possibleConstructorReturn(this, (_ref = SectionDescriptor.__proto__ || Object.getPrototypeOf(SectionDescriptor)).call.apply(_ref, [this].concat(args))), _this), _this.onAddGadget = function (gadget) {
      var initialTemplate = (0, _lodash.isFunction)((0, _lodash.get)(gadget, 'meta.initialTemplate')) ? gadget.meta.initialTemplate() : {};
      var newGadget = _extends({}, initialTemplate, {
        type: gadget.type,
        id: _shortid2.default.generate()
      });
      var newChildren = [].concat(_toConsumableArray(_this.props.section.children), [newGadget]);
      _this.props.onChange((0, _lodash.get)(_this, 'props.section.id'), _extends({}, _this.props.section, {
        children: newChildren
      }));

      _this.props.onClickSettings(newGadget.id);
    }, _temp), _possibleConstructorReturn(_this, _ret);
  }

  _createClass(SectionDescriptor, [{
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          section = _props.section,
          gadgets = _props.gadgets,
          onClickSettings = _props.onClickSettings,
          SectionRenderer = _props.SectionRenderer,
          GadgetRenderer = _props.GadgetRenderer,
          onMove = _props.onMove,
          SectionDropzone = _props.SectionDropzone,
          isDragging = _props.isDragging,
          onDelete = _props.onDelete;

      var children = section.children;
      return _react2.default.createElement(
        'div',
        { className: (0, _classnames2.default)(_style2.default['section-container'], {}) },
        _react2.default.createElement(_gadgetDescriptor2.default, {
          gadget: section,
          gadgets: gadgets,
          descriptorLabel: 'Section Name',
          onClickSettings: onClickSettings,
          className: _style2.default['section-descriptor'],
          isDragging: isDragging,
          onDelete: onDelete
        }),
        _react2.default.createElement(
          SectionDropzone,
          { parentId: section.id, isDragging: isDragging },
          function (DropZone) {
            return _react2.default.createElement(
              'div',
              { className: _style2.default.sectionBody },
              _react2.default.createElement(
                'div',
                { className: _style2.default['section-children'] },
                (0, _lodash.map)(children, function (child) {
                  if (child.children) {
                    return _react2.default.createElement(SectionRenderer, {
                      key: child.id,
                      section: child,
                      onChange: _this2.props.onChange,
                      gadgets: gadgets,
                      onClickSettings: onClickSettings,
                      SectionRenderer: SectionRenderer,
                      GadgetRenderer: GadgetRenderer,
                      onMove: onMove,
                      parentId: section.id,
                      SectionDropzone: SectionDropzone,
                      isDragging: isDragging,
                      onDelete: onDelete
                    });
                  } else {
                    return _react2.default.createElement(GadgetRenderer, {
                      key: child.id,
                      gadget: child,
                      gadgets: gadgets,
                      onClickSettings: onClickSettings,
                      onMove: onMove,
                      parentId: section.id,
                      isDragging: isDragging,
                      onDelete: onDelete
                    });
                  }
                })
              ),
              _react2.default.createElement('div', { style: { flex: '1', height: 8 } }),
              children.length === 0 && DropZone,
              _react2.default.createElement(_addItem2.default, { gadgets: gadgets, onGadgetSelection: _this2.onAddGadget }),
              _react2.default.createElement('div', { style: { flex: '1', height: 10 } })
            );
          }
        )
      );
    }
  }]);

  return SectionDescriptor;
}(_react.Component);

SectionDescriptor.propTypes = {
  section: _propTypes2.default.object.isRequired,
  gadgets: _propTypes2.default.object.isRequired,
  onChange: _propTypes2.default.func.isRequired
};
exports.default = SectionDescriptor;