'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _formbot = require('@kuali/formbot');

var _configSettings = require('./config-settings.css');

var _configSettings2 = _interopRequireDefault(_configSettings);

var _generalSettings = require('./general-settings');

var _generalSettings2 = _interopRequireDefault(_generalSettings);

var _configProgressiveDisclosure = require('./config-progressive-disclosure');

var _configProgressiveDisclosure2 = _interopRequireDefault(_configProgressiveDisclosure);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var gatherGadgetsComplex = _formbot.utils.gatherGadgetsComplex;

var FormbotConfigSettings = function (_Component) {
  _inherits(FormbotConfigSettings, _Component);

  function FormbotConfigSettings(props) {
    _classCallCheck(this, FormbotConfigSettings);

    var _this = _possibleConstructorReturn(this, (FormbotConfigSettings.__proto__ || Object.getPrototypeOf(FormbotConfigSettings)).call(this, props));

    _this.handleDismiss = function (_) {
      var _this$props = _this.props,
          template = _this$props.template,
          trash = _this$props.trashed,
          onChange = _this$props.onChange;

      if (!(0, _lodash.get)(_this, 'props.value.label') && !(0, _lodash.get)(_this, 'props.value.formKey') && !(0, _lodash.get)(_this, 'props.value.children.length')) {
        var gadgetIdToDelete = _this.props.id;
        var gadgetInstances = gatherGadgetsComplex(template, null, trash);
        var gadgetInstance = (0, _lodash.find)(gadgetInstances, { id: gadgetIdToDelete });
        var trashed = null;
        if (!gadgetInstance.parent) {
          onChange({}, null, trashed);
        }

        var newParent = (0, _lodash.cloneDeep)(gadgetInstance.parent);
        var childIndex = (0, _lodash.findIndex)(gadgetInstance.parent.children, function (child) {
          return child.id === gadgetIdToDelete;
        });
        if (childIndex !== -1) newParent.children.splice(childIndex, 1);
        onChange(gadgetInstance.parent.id, newParent, trashed);
      }
      _this.props.dismiss();
    };

    _this.handleSaveClick = function (_) {
      if ((0, _lodash.isEmpty)(_this.state.pendingValues.label)) {
        if (!_this.state.validating) {
          _this.setState({ validating: true });
        }
        return;
      }
      var _this$props2 = _this.props,
          trashed = _this$props2.trashed,
          Formbot = _this$props2.Formbot,
          template = _this$props2.template;
      var onChange = _this.props.onChange;

      var gadgetDefinition = Formbot.getGadget(_this.state.pendingValues.type);

      var progressiveDisclosure = _this.state.pendingValues.progressiveDisclosure;

      if ((0, _lodash.get)(progressiveDisclosure, 'parts.length', 0) > 0) {
        var invalidPartsExist = (0, _lodash.some)(progressiveDisclosure.parts, function (part) {
          if (!part.data) {
            return true;
          }
          var gadgetReferenced = _formbot.utils.recursiveFind(template.children, {
            formKey: part.formKey
          });
          if (!gadgetReferenced) {
            return true;
          }

          var validationFunction = (0, _lodash.get)(Formbot.getGadget(gadgetReferenced.type), 'progressiveDisclosure.configIsValid', function () {
            return (0, _lodash.size)(part.data) > 0;
          });
          return !validationFunction(part.data);
        });

        if (invalidPartsExist) {
          _this.setState({ validating: true });
          return;
        }
      }
      if (!_this.state.pendingValues.formKey && !gadgetDefinition.layout) {
        var label = (0, _lodash.get)(_this, 'state.pendingValues.label', '');
        var formKey = (0, _lodash.camelCase)(label);
        var allGadgets = _formbot.utils.gatherGadgetsById(template, trashed);
        var takenKeys = _this.takenKeys(allGadgets, trashed, Formbot);
        for (var i = 1; (0, _lodash.includes)(takenKeys, formKey); ++i) {
          formKey = (0, _lodash.camelCase)(label) + i;
        }

        _this.state.pendingValues.formKey = formKey;
      }
      onChange(_this.props.id, _this.state.pendingValues);
      _this.props.dismiss();
    };

    _this.takenKeys = function (allGadgets, trashed, Formbot) {
      return (0, _lodash.uniq)((0, _lodash.compact)([].concat(_toConsumableArray((0, _lodash.map)((0, _lodash.values)(allGadgets), 'formKey')), _toConsumableArray((0, _lodash.map)(trashed, 'formKey')), _toConsumableArray((0, _lodash.keys)(Formbot.context.presets)))));
    };

    _this.state = { selected: 0, pendingValues: (0, _lodash.cloneDeep)(props.value || {}), validating: false };
    _this.handlePropChange = _this.handlePropChange.bind(_this);
    _this.renderFieldPreview = _this.renderFieldPreview.bind(_this);
    return _this;
  }

  _createClass(FormbotConfigSettings, [{
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(newProps) {
      this.setState({
        pendingValues: (0, _lodash.cloneDeep)(newProps.value),
        validating: false
      });
    }
  }, {
    key: 'select',
    value: function select(e, selected) {
      e.stopPropagation();
      this.setState({ selected: selected });
    }
  }, {
    key: 'handlePropChange',
    value: function handlePropChange(name, val) {
      var values = this.state.pendingValues;
      (0, _lodash.set)(values, name, val);
      this.setState({
        pendingValues: values
      });
    }
  }, {
    key: 'renderFieldPreview',
    value: function renderFieldPreview(Formbot, template, id, context) {
      var gTemplate = _formbot.utils.findGadgetById(template, id);
      var aTemplate = Object.assign({}, gTemplate, this.state.pendingValues);
      var gDefinition = Formbot.getGadget(gTemplate.type);
      aTemplate.formKey = 'temp';
      return Formbot.renderGadget(Formbot, 'edit', aTemplate, {
        context: context,
        shouldShow: true,
        onChange: _lodash.noop,
        value: gDefinition.defaultValue
      });
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          context = _props.context,
          Formbot = _props.Formbot,
          value = _props.value,
          template = _props.template,
          trashed = _props.trashed,
          id = _props.id;
      var _state = this.state,
          pendingValues = _state.pendingValues,
          validating = _state.validating;

      var allGadgets = _formbot.utils.gatherGadgetsById(template, trashed);
      var GadgetConfig = _formbot.utils.getGadgetConfig(Formbot, template, id);
      var meta = _formbot.utils.getGadgetMeta(Formbot, template, id);
      var takenKeys = this.takenKeys(allGadgets, trashed, Formbot);

      var progressiveDisclosures = (0, _lodash.reduce)(allGadgets, function (memo, gadget) {
        var definition = Formbot.getGadget(gadget.type);
        if (!definition) {
          return memo;
        }
        var progressiveDisclosure = definition.progressiveDisclosure;

        if (progressiveDisclosure && value.formKey !== gadget.formKey) {
          // This is not very performant. It's essentially traversing the entire
          // formbot template on every item. The lookup to the parents should be
          // stored somehow on the gadgets. This would be a breaking change on
          // progressive disclosure and is perhaps an indication of a need to
          // remodel the data handling in formbot due to evolving requirements.
          var path = _formbot.utils.findGadgetPathById(template, gadget.id);
          var parentPath = path.split('.').slice(0, -2);
          var parent = parentPath.reduce(function (parent, path) {
            return parent[path];
          }, template);
          var component = progressiveDisclosure.component,
              validator = progressiveDisclosure.configIsValid;

          memo.push({
            parent: {
              id: parent.id,
              label: parent.label
            },
            formKey: gadget.formKey,
            label: gadget.label,
            component: component,
            details: gadget.details || {},
            validator: validator
          });
        }
        return memo;
      }, Formbot.getProgressiveDisclosures());

      var actions = [_react2.default.createElement(_kualiUi.RaisedButton, { label: 'Cancel', onClick: this.handleDismiss }), _react2.default.createElement(
        _kualiUi.RaisedButton,
        {
          label: 'Save',
          onClick: this.handleSaveClick,
          disabled: validating && (0, _lodash.isEmpty)(this.state.pendingValues.label)
        },
        _react2.default.createElement(_kualiUi.Icon, { name: 'check' })
      )];

      return _react2.default.createElement(
        _kualiUi.Dialog,
        {
          id: 'config-dialog-' + value.id,
          modal: true,
          title: meta.lbl,
          actions: actions,
          visible: true,
          onHide: this.handleDismiss,
          focusOnMount: true,
          containFocus: true,
          className: _configSettings2.default.dialog,
          lastChild: true,
          portal: true
        },
        _react2.default.createElement(
          'div',
          {
            className: (0, _classnames2.default)(_configSettings2.default['gadget-config--section'], _configSettings2.default['field-preview-container'])
          },
          _react2.default.createElement(
            'h3',
            null,
            'Field Preview'
          ),
          this.renderFieldPreview(Formbot, template, id, context)
        ),
        _react2.default.createElement(
          'div',
          { className: _configSettings2.default['gadget-config--section'] },
          _react2.default.createElement(
            'h3',
            null,
            'General'
          ),
          _react2.default.createElement(_generalSettings2.default, {
            value: pendingValues,
            onChange: this.handlePropChange,
            progressiveDisclosures: progressiveDisclosures,
            takenKeys: takenKeys,
            gadgetMeta: meta,
            validating: validating
          })
        ),
        _react2.default.createElement(
          'div',
          { className: _configSettings2.default['gadget-config--section'] },
          _react2.default.createElement(
            'h3',
            null,
            'Progressive Disclosure'
          ),
          _react2.default.createElement(_configProgressiveDisclosure2.default, {
            context: context,
            value: pendingValues,
            onChange: this.handlePropChange,
            progressiveDisclosures: progressiveDisclosures,
            validating: validating
          })
        ),
        GadgetConfig && _react2.default.createElement(
          'div',
          { className: _configSettings2.default['gadget-config--section'] },
          _react2.default.createElement(GadgetConfig, {
            context: context,
            id: id,
            value: pendingValues.details || {},
            gadgets: allGadgets,
            onChange: function onChange(newVal) {
              _this2.handlePropChange('details', newVal);
            }
          })
        )
      );
    }
  }]);

  return FormbotConfigSettings;
}(_react.Component);

FormbotConfigSettings.displayName = 'FormbotConfigSettings';
FormbotConfigSettings.propTypes = {
  dismiss: _propTypes2.default.func.isRequired,
  Formbot: _propTypes2.default.object.isRequired,
  id: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  template: _propTypes2.default.object.isRequired,
  trashed: _propTypes2.default.array.isRequired,
  value: _propTypes2.default.object.isRequired
};
exports.default = FormbotConfigSettings;