'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _forms = require('@kuali/kuali-ui/lib/forms');

var _utils = require('./utils');

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Checkbox = require('react-md/lib/SelectionControls/Checkbox');

var _Checkbox2 = _interopRequireDefault(_Checkbox);

var _generalSettings = require('./general-settings.css');

var _generalSettings2 = _interopRequireDefault(_generalSettings);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var Quill = void 0;
if (typeof document !== 'undefined') {
  Quill = require('react-quill');
}

var toolbarItems = [[{ font: [] }], [{ size: [] }], [{ align: [] }], ['bold', 'italic', 'strike', 'underline'], [{ color: [] }, { background: [] }], [{ list: 'ordered' }, { list: 'bullet' }], ['link']];

var gadgetSizeMenuItems = {
  small: 'Small (A few words)',
  medium: 'Medium (A small sentence)',
  large: 'Large (A large sentence)',
  xlarge: 'Extra Large (A paragraph)'
};

var keyboard = {
  bindings: {
    tab: {
      key: 9,
      handler: function handler() {
        return true;
      } // allow normal tab key event propagation
    }
  }
};

var GeneralSettings = function (_Component) {
  _inherits(GeneralSettings, _Component);

  function GeneralSettings() {
    _classCallCheck(this, GeneralSettings);

    return _possibleConstructorReturn(this, (GeneralSettings.__proto__ || Object.getPrototypeOf(GeneralSettings)).apply(this, arguments));
  }

  _createClass(GeneralSettings, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          _onChange = _props.onChange,
          value = _props.value,
          gadgetMeta = _props.gadgetMeta,
          validating = _props.validating;


      var sizeMenu = gadgetMeta && gadgetMeta.sizes ? (0, _lodash.map)(gadgetMeta.sizes, function (size) {
        return { name: (0, _lodash.get)(gadgetSizeMenuItems, size), value: size };
      }) : null;
      return _react2.default.createElement(
        'div',
        null,
        _react2.default.createElement(
          _kualiUi.Form,
          { showGrid: true },
          _react2.default.createElement(
            'div',
            { className: _generalSettings2.default.textContainer },
            _react2.default.createElement(
              _kualiUi.FieldGroup,
              null,
              _react2.default.createElement(
                _forms.FieldCell,
                null,
                _react2.default.createElement(
                  _kualiUi.Label,
                  { htmlFor: 'fieldLabel' },
                  'Field Label'
                ),
                _react2.default.createElement(_kualiUi.TextField, {
                  id: 'fieldLabel',
                  error: validating && (0, _lodash.isEmpty)(value.label),
                  defaultValue: value.label,
                  onChange: function onChange(value) {
                    _onChange('label', value);
                  }
                })
              )
            ),
            _react2.default.createElement(
              _kualiUi.FieldGroup,
              null,
              _react2.default.createElement(
                _forms.FieldCell,
                null,
                _react2.default.createElement(_Checkbox2.default, {
                  id: 'displayLabel',
                  checked: (0, _lodash.get)(value, 'displayLabel', !(0, _lodash.get)(value, 'displayQuestionOnly', false)),
                  onChange: function onChange(value) {
                    _onChange('displayLabel', value);
                  },
                  label: 'Display Field Label on form'
                })
              )
            )
          ),
          _react2.default.createElement(
            'div',
            { className: _generalSettings2.default.textContainer },
            _react2.default.createElement(
              _kualiUi.FieldGroup,
              null,
              _react2.default.createElement(
                _forms.FieldCell,
                null,
                _react2.default.createElement(
                  _kualiUi.Label,
                  { className: _generalSettings2.default.quillLabel, htmlFor: 'question' },
                  'Question (optional)'
                ),
                _react2.default.createElement(Quill, {
                  className: _generalSettings2.default.quill,
                  modules: { toolbar: toolbarItems, keyboard: keyboard },
                  theme: 'snow',
                  defaultValue: (0, _utils.sanitize)(value.question || ''),
                  onChange: function onChange(val) {
                    return _onChange('question', val);
                  }
                })
              )
            ),
            _react2.default.createElement(
              _kualiUi.FieldGroup,
              null,
              _react2.default.createElement(
                _forms.FieldCell,
                null,
                _react2.default.createElement(_Checkbox2.default, {
                  id: 'displayQuestion',
                  checked: (0, _lodash.get)(value, 'displayQuestion', true),
                  onChange: function onChange(value) {
                    _onChange('displayQuestion', value);
                  },
                  label: 'Display Question on form'
                })
              )
            )
          ),
          _react2.default.createElement(
            'div',
            { className: _generalSettings2.default.textContainer },
            _react2.default.createElement(
              _kualiUi.FieldGroup,
              null,
              _react2.default.createElement(
                _forms.FieldCell,
                null,
                _react2.default.createElement(
                  _kualiUi.Label,
                  {
                    htmlFor: 'fieldDescription',
                    className: _generalSettings2.default.quillLabel
                  },
                  'Description (optional)'
                ),
                _react2.default.createElement(Quill, {
                  className: _generalSettings2.default.quill,
                  modules: { toolbar: toolbarItems, keyboard: keyboard },
                  theme: 'snow',
                  defaultValue: (0, _utils.sanitize)(value.desc || ''),
                  onChange: function onChange(val) {
                    return _onChange('desc', val);
                  }
                })
              )
            ),
            _react2.default.createElement(
              _kualiUi.FieldGroup,
              null,
              _react2.default.createElement(
                _forms.FieldCell,
                null,
                _react2.default.createElement(_Checkbox2.default, {
                  id: 'displayDescInline',
                  checked: (0, _lodash.get)(value, 'displayDescInline', true),
                  onChange: function onChange(value) {
                    _onChange('displayDescInline', value);
                  },
                  label: 'Display Description inline in form'
                })
              )
            )
          ),
          sizeMenu && _react2.default.createElement(
            _kualiUi.FieldGroup,
            null,
            _react2.default.createElement(
              _forms.FieldCell,
              null,
              _react2.default.createElement(
                _kualiUi.Label,
                { htmlFor: 'fieldSize' },
                'Field Width'
              ),
              _react2.default.createElement(_kualiUi.SelectField, {
                id: 'fieldSize',
                placeholder: 'Choose a field width',
                menuItems: sizeMenu,
                itemLabel: 'name',
                itemValue: 'value',
                onChange: function onChange(value) {
                  _onChange('fieldSize', value);
                },
                value: value.fieldSize
              })
            )
          )
        )
      );
    }
  }]);

  return GeneralSettings;
}(_react.Component);

GeneralSettings.displayName = 'GeneralSettings';
GeneralSettings.propTypes = {
  onChange: _propTypes2.default.func.isRequired,
  onUpdateFormKey: _propTypes2.default.func,
  takenKeys: _propTypes2.default.array.isRequired,
  value: _propTypes2.default.object.isRequired,
  gadgetMeta: _propTypes2.default.object,
  validating: _propTypes2.default.bool.isRequired
};
exports.default = GeneralSettings;