/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { FlatButton, Icon, Dialog } from '@kuali/kuali-ui'
import { groupBy, map, flatMap, reject } from 'lodash'
import GadgetButton from '../gadget-button'
import styles from './style.css'

export default class AddItem extends Component {
  static propTypes = {
    gadgets: PropTypes.object.isRequired,
    onGadgetSelection: PropTypes.func.isRequired,
    test: PropTypes.object
  }

  state = {
    visible: false
  }

  handleToggleVisibility = e => {
    this.setState({ visible: !this.state.visible })
  }

  handleRequestClose = e => {
    this.setState({ visible: false })
  }

  handleGadgetButtonClick = gadget => {
    this.props.onGadgetSelection(gadget)
    this.setState({ visible: false })
  }

  gadgetList () {
    const flatGadgets = flatMap(this.props.gadgets, (gadget, type) => ({
      ...gadget,
      type
    }))
    const filteredGadgets = reject(flatGadgets, 'meta.hidden')
    const gadgetGroups = groupBy(filteredGadgets, 'meta.category')
    return map(gadgetGroups, (gadgets, groupName) => {
      const gadgetList = map(gadgets, (gadget, index) => {
        return (
          <GadgetButton
            key={gadget.meta.lbl}
            style={{ marginLeft: 0 }}
            gadget={gadget}
            onClick={this.handleGadgetButtonClick}
            className={styles['gadget-button']}
          />
        )
      })
      return (
        <div key={groupName} className={styles['gadget-section']}>
          <h4 className={styles['gadget-section--header']}>{groupName}</h4>
          <div className={styles['gadget-section--list']}>{gadgetList}</div>
          <div className={styles['gadget-section--divider']} />
        </div>
      )
    })
  }

  render () {
    const { visible } = this.state
    return (
      <div className={styles['container']}>
        <FlatButton
          label='Add Item'
          onClick={this.handleToggleVisibility}
          className={styles['add-gadget-button']}
        >
          <Icon name='add' />
        </FlatButton>
        <Dialog
          focusOnMount
          containFocus
          className={styles.popover}
          contentClassName={styles['popover-content']}
          modal
          onHide={this.handleRequestClose}
          title='Add Item'
          visible={visible}
        >
          {this.gadgetList()}
        </Dialog>
      </div>
    )
  }
}
