/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import styles from '../gadget-descriptor/style.css'
import { Icon } from '@kuali/kuali-ui'

export default class DescriptorIcon extends Component {
  static propTypes = {
    name: PropTypes.string.isRequired,
    iconStyle: PropTypes.object
  }

  render () {
    return (
      <Icon
        style={this.props.iconStyle}
        name={this.props.name}
        className={styles['descriptor-icon']}
      />
    )
  }
}
