/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { FlatButton, Icon } from '@kuali/kuali-ui'

export default class GadgetButton extends Component {
  static propTypes = {
    className: PropTypes.string,
    gadget: PropTypes.object.isRequired,
    onClick: PropTypes.func.isRequired
  }

  handleClick = e => {
    const { onClick, gadget } = this.props
    onClick(gadget)
  }

  render () {
    const { className, gadget } = this.props
    const gadgetName = gadget.meta.lbl
    return (
      <FlatButton
        className={className}
        key={gadgetName}
        label={gadget.meta.lbl}
        onClick={this.handleClick}
      >
        <Icon name={gadget.meta.icon} />
      </FlatButton>
    )
  }
}
