/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import cx from 'classnames'
import styles from './style.css'
import DescriptorIcon from '../descriptor-icon'
import { IconButton } from '@kuali/kuali-ui'
import { capitalize, get } from 'lodash'

export default class GadgetDescriptor extends Component {
  static propTypes = {
    gadget: PropTypes.object.isRequired,
    className: PropTypes.string,
    descriptorLabel: PropTypes.string
  }

  render () {
    const {
      gadget,
      gadgets,
      className,
      descriptorLabel,
      onClickSettings,
      onDelete
    } = this.props
    const descriptorClassName = cx(styles['descriptor-container'], className)
    const type = gadgets[gadget.type]

    return (
      <div className={descriptorClassName}>
        <div
          className={cx(
            styles['descriptor-col1'],
            styles['descriptor-col1-width']
          )}
        >
          <DescriptorIcon name='menu' />
          <span>{get(type, 'meta.lbl', 'Missing Label')}</span>
        </div>
        <div
          className={cx(
            styles['label-container'],
            styles['label-container-width']
          )}
        >
          <div className={styles['column-header']}>
            {descriptorLabel || (
              <div style={{ display: 'flex', flexFlow: 'row nowrap' }}>
                <span>Field Label</span>
                <span className={styles['label-desc-long']}>
                  &nbsp;+ Description
                </span>
              </div>
            )}
          </div>
          <div>{gadget.label}</div>
        </div>
        <div className={styles['size-col']}>
          <div
            className={cx(
              styles['size-container'],
              styles['size-container-width']
            )}
          >
            <div className={styles['column-header']}>Size</div>
            <div>{capitalize(gadget.fieldSize) || 'Large'}</div>
          </div>
        </div>
        <div style={{ flex: '1', justifyContent: 'flex-end', display: 'flex' }}>
          <IconButton
            aria-label={`Delete ${gadget.label} gadget`}
            onClick={() => onDelete(gadget.id)}
          >
            <DescriptorIcon
              name='delete'
              iconStyle={{
                padding: 0
              }}
            />
          </IconButton>
          <IconButton
            aria-label={`Configure ${gadget.label} gadget`}
            onClick={() => onClickSettings(gadget.id)}
          >
            <DescriptorIcon
              name='settings'
              iconStyle={{
                padding: 0
              }}
            />
          </IconButton>
        </div>
      </div>
    )
  }
}
