/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import shortid from 'shortid'
import styles from '../gadget-descriptor/style.css'
import cx from 'classnames'
import { get, map, isFunction } from 'lodash'
import GadgetDescriptor from '../gadget-descriptor'
import AddItem from '../add-item'

export default class SectionDescriptor extends Component {
  static propTypes = {
    section: PropTypes.object.isRequired,
    gadgets: PropTypes.object.isRequired,
    onChange: PropTypes.func.isRequired
  }

  onAddGadget = gadget => {
    const initialTemplate = isFunction(get(gadget, 'meta.initialTemplate'))
      ? gadget.meta.initialTemplate()
      : {}
    const newGadget = {
      ...initialTemplate,
      type: gadget.type,
      id: shortid.generate()
    }
    const newChildren = [...this.props.section.children, newGadget]
    this.props.onChange(get(this, 'props.section.id'), {
      ...this.props.section,
      children: newChildren
    })

    this.props.onClickSettings(newGadget.id)
  }

  render () {
    const {
      section,
      gadgets,
      onClickSettings,
      SectionRenderer,
      GadgetRenderer,
      onMove,
      SectionDropzone,
      isDragging,
      onDelete
    } = this.props
    const children = section.children
    return (
      <div className={cx(styles['section-container'], {})}>
        <GadgetDescriptor
          gadget={section}
          gadgets={gadgets}
          descriptorLabel='Section Name'
          onClickSettings={onClickSettings}
          className={styles['section-descriptor']}
          isDragging={isDragging}
          onDelete={onDelete}
        />
        <SectionDropzone parentId={section.id} isDragging={isDragging}>
          {DropZone => (
            <div className={styles.sectionBody}>
              <div className={styles['section-children']}>
                {map(children, child => {
                  if (child.children) {
                    return (
                      <SectionRenderer
                        key={child.id}
                        section={child}
                        onChange={this.props.onChange}
                        gadgets={gadgets}
                        onClickSettings={onClickSettings}
                        SectionRenderer={SectionRenderer}
                        GadgetRenderer={GadgetRenderer}
                        onMove={onMove}
                        parentId={section.id}
                        SectionDropzone={SectionDropzone}
                        isDragging={isDragging}
                        onDelete={onDelete}
                      />
                    )
                  } else {
                    return (
                      <GadgetRenderer
                        key={child.id}
                        gadget={child}
                        gadgets={gadgets}
                        onClickSettings={onClickSettings}
                        onMove={onMove}
                        parentId={section.id}
                        isDragging={isDragging}
                        onDelete={onDelete}
                      />
                    )
                  }
                })}
              </div>
              <div style={{ flex: '1', height: 8 }} />
              {children.length === 0 && DropZone}
              <AddItem gadgets={gadgets} onGadgetSelection={this.onAddGadget} />
              <div style={{ flex: '1', height: 10 }} />
            </div>
          )}
        </SectionDropzone>
      </div>
    )
  }
}
