/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { mount } from 'enzyme'
import React from 'react'
import GeneralConditions from '../general-conditions'

describe('General Conditions', () => {
  let mockPDComponent
  let mockValue
  let mockOnChange

  beforeEach(() => {
    mockPDComponent = 'mockPDComponent'
    mockValue = {
      progressiveDisclosure: {
        active: false
      }
    }
    mockOnChange = jest.fn()
  })

  it('should render', () => {
    const wrapper = mount(
      <GeneralConditions
        value={mockValue}
        conditionComponent={mockPDComponent}
        onChange={mockOnChange}
      />
    )
    expect(wrapper).toMatchSnapshot()
  })

  it('should render when active', () => {
    mockValue.progressiveDisclosure.active = true
    const wrapper = mount(
      <GeneralConditions
        value={mockValue}
        conditionComponent={mockPDComponent}
        onChange={mockOnChange}
      />
    )
    expect(wrapper).toMatchSnapshot()
  })
})
