/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

/* eslint react/prefer-stateless-function: 1 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { DragDropContext } from 'react-dnd'
import HTML5Backend from 'react-dnd-html5-backend'

class FormbotConfigWrapper extends Component {
  static displayName = 'FormbotConfigWrapper'

  static propTypes = {
    children: PropTypes.node.isRequired,
    className: PropTypes.string
  }

  render () {
    const { children, className } = this.props
    return <div className={className}>{children}</div>
  }
}

export default DragDropContext(HTML5Backend)(FormbotConfigWrapper)
