/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import cx from 'classnames'
import React from 'react'
import PropTypes from 'prop-types'

import { detectIE } from './utils'

export default function FormbotEdit (props) {
  const {
    className,
    context,
    data,
    Formbot,
    multipageNum,
    onChange,
    template,
    trashed
  } = props
  const classes = cx(className, { 'ie-fixes': detectIE() })
  return (
    <div className={classes}>
      {Formbot.render('edit', template, trashed, data, {
        context,
        onChange,
        multipageNum
      })}
    </div>
  )
}

FormbotEdit.displayName = 'FormbotEdit'

FormbotEdit.propTypes = {
  className: PropTypes.string,
  context: PropTypes.any,
  data: PropTypes.object.isRequired,
  Formbot: PropTypes.object.isRequired,
  multipageNum: PropTypes.number,
  onChange: PropTypes.func.isRequired,
  template: PropTypes.object.isRequired,
  trashed: PropTypes.array.isRequired
}
