/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { Form, FieldGroup, Label } from '@kuali/kuali-ui'
import { FieldCell } from '@kuali/kuali-ui/lib/forms'
import { Switch } from 'react-md/lib/SelectionControls'

import styles from './general-conditions.css'

export default class GeneralConditions extends Component {
  constructor (props) {
    super(props)
    this.state = {
      active:
        props.value.progressiveDisclosure &&
        props.value.progressiveDisclosure.active
    }
    this.handleActiveChange = this.handleActiveChange.bind(this)
  }

  handleActiveChange (checked) {
    this.state.active = checked
    this.props.onChange('progressiveDisclosure', this.state)
  }

  render () {
    return (
      <div className={styles.progDisc}>
        <Form showGrid>
          <FieldGroup>
            <FieldCell>
              <Label htmlFor='progDiscActive'>
                Is this a conditional field?
              </Label>
              <div className={styles.progDiscActive}>
                <span>No</span>
                <Switch
                  id='progDiscActive'
                  type='switch'
                  name='progDiscActive'
                  defaultChecked={this.state.active}
                  onChange={this.handleActiveChange}
                />
                <span>Yes</span>
              </div>
            </FieldCell>
          </FieldGroup>
        </Form>
        {this.state.active && <this.props.conditionComponent {...this.props} />}
      </div>
    )
  }
}

GeneralConditions.propTypes = {
  onChange: PropTypes.func.isRequired,
  value: PropTypes.shape({
    progressiveDisclosure: PropTypes.object,
    value: PropTypes.string,
    type: PropTypes.string
  }).isRequired
}
