'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

/* eslint-disable max-len */

var autoId = 0;
function addIds(obj) {
  obj.id = 'id-' + autoId++;
  if (obj.children) obj.children.forEach(function (child) {
    return addIds(child);
  });
  return obj;
}

exports.default = addIds({
  type: 'Column',
  children: [{
    type: 'Section',
    children: [{
      type: 'Spacer',
      children: [],
      desc: 'Welcome to the Greendale Community College online application. Fill out the information below and submit your application. The deadline for Winter 2017 applications is August 1, 2016.'
    }],
    desc: '',
    label: 'Greendale Community College | Apply'
  }, {
    type: 'Section',
    children: [{
      type: 'Column',
      children: [{
        type: 'Row',
        children: [{
          type: 'Text',
          formKey: 'firstName1',
          label: 'First Name',
          desc: 'This is a est'
        }, {
          type: 'Text',
          formKey: 'middleName1',
          label: 'Middle Name'
        }, {
          type: 'Text',
          formKey: 'lastName1',
          label: 'Last Name',
          desc: ''
        }, {
          type: 'Text',
          formKey: 'nameSuffixIeJrSrIii',
          label: 'Name Suffix (ie Jr, Sr, III)',
          progressiveDisclosure: null,
          details: {
            placeholder: 'put something here'
          }
        }]
      }, {
        type: 'Textarea',
        formKey: 'asdfadsf',
        label: 'Please enter any additional names used in your academic records, test scores, etc. (format First Middle last)',
        progressiveDisclosure: {
          type: 'all',
          parts: [{
            formKey: 'firstName1',
            data: {
              type: 'contains',
              value: 'testing'
            }
          }, {
            formKey: 'asdfadsf',
            data: {
              type: 'contains',
              value: 'hrrrm'
            }
          }]
        }
      }, {
        type: 'Row',
        children: [{
          type: 'Textarea',
          formKey: 'haveYouEverAppliedToThisCampusBeforeIfYesWhichSemesterAndWhatActionWasTakenOnThatApplication',
          label: 'Have you ever applied to this campus before? If yes, which semester and what action was taken on that application?',
          parentDetails: {
            flex: '2'
          }
        }, {
          type: 'Radios',
          formKey: 'haveYouAttendedThisCampusBefore',
          label: 'Have you attended this campus before?',
          details: {
            options: [{
              lbl: 'No',
              key: 'no1'
            }, {
              lbl: 'Maybe',
              key: 'maybe1'
            }]
          },
          parentDetails: {
            flex: ''
          }
        }]
      }]
    }],
    label: 'Name'
  }, {
    type: 'Section',
    children: [{
      type: 'Column',
      children: [{
        type: 'Row',
        children: [{
          type: 'Text',
          formKey: 'streetLine12',
          label: 'Street Line 1'
        }, {
          type: 'Text',
          formKey: 'streetLine22',
          label: 'Street Line 2'
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Row',
          children: [{
            type: 'Text',
            formKey: 'city1',
            label: 'City'
          }]
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Row',
          children: [{
            type: 'Text',
            formKey: 'zipPostalCode',
            label: 'Zip/Postal Code'
          }, {
            type: 'CountryDropdown',
            formKey: 'countryIfNotUs1',
            label: 'Country (if not US)'
          }, {
            type: 'Text',
            formKey: 'internationalProvincePostalCode',
            label: 'International Province/Postal Code'
          }]
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Row',
          children: [{
            type: 'Text',
            formKey: 'usPhone',
            label: 'US Phone'
          }, {
            type: 'Text',
            formKey: 'otherUsPhone',
            label: 'Other US Phone'
          }, {
            type: 'Text',
            formKey: 'internationalPhone',
            label: 'International Phone'
          }]
        }]
      }, {
        type: 'Checkboxes',
        formKey: 'useThisInformationForMyMailingAddress',
        label: '',
        details: {
          options: [{
            lbl: 'Use this information for my Mailing Address',
            key: 'yes1'
          }]
        }
      }]
    }],
    label: 'Permanent Address and Phone'
  }, {
    children: [{
      type: 'Column',
      children: [{
        type: 'Row',
        children: [{
          type: 'RichText',
          formKey: 'soSadNotMaterial',
          label: 'so sad, not material'
        }]
      }]
    }],
    type: 'Section',
    label: 'Personal Essays'
  }, {
    type: 'Section',
    children: [{
      type: 'Column',
      children: [{
        type: 'Spacer',
        children: [],
        desc: 'Enter your Personal Information. Gender, ethnicity, and birth date are for informational purposes only. Please be sure to provide your U.S. Social Security Number, if you have one; this will ensure that University programs and services are available with the least delay. Acceptance is not based on this information. Go to HELP for additional information regarding the ethnicity question. The educational background and military affiliation questions are optional. No information provided will be used in a discriminatory manner.'
      }, {
        type: 'Column',
        children: [{
          type: 'Row',
          children: [{
            type: 'Dropdown',
            formKey: 'usCitizenshipStatus',
            label: 'US Citizenship Status',
            details: {
              options: [{
                lbl: 'Citizen (US)',
                key: 'citizenUs1'
              }, {
                lbl: 'Non-US Citizen',
                key: 'nonUsCitizen1'
              }, {
                lbl: 'US National or CoFA Citizen',
                key: 'usNationalOrCoFaCitizen1'
              }, {
                lbl: 'US Permanent Resident',
                key: 'usPermanentResident1'
              }]
            }
          }, {
            type: 'Text',
            formKey: 'email',
            label: 'Email'
          }, {
            type: 'Text',
            formKey: 'verifyEmail',
            label: 'Verify Email'
          }]
        }]
      }, {
        type: 'Row',
        children: [{
          type: 'Dropdown',
          formKey: 'gender1',
          label: 'Gender',
          details: {
            options: [{
              lbl: 'Female',
              key: 'femal1'
            }, {
              lbl: 'Male',
              key: 'male1'
            }]
          }
        }, {
          type: 'Text',
          formKey: 'socialSecurityNumber',
          label: 'Social Security Number'
        }, {
          type: 'Spacer',
          children: []
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Hr',
          children: []
        }, {
          type: 'Radios',
          formKey: 'whatIsYourEthnicity',
          label: 'What is your ethnicity?',
          details: {
            options: [{
              lbl: 'Hispanic or Latino',
              key: 'hispanicOrLatino1'
            }, {
              lbl: 'Not Hispanic or Latino',
              key: 'notHispanicOrLatino1'
            }]
          }
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Column',
          children: [{
            type: 'Spacer',
            children: [],
            desc: 'Select one or more races to indicate what you consider yourself to be.'
          }]
        }, {
          type: 'Row',
          children: [{
            type: 'Checkboxes',
            formKey: 'americanIndianOrAlaskaNative',
            label: 'American Indian or Alaska Native',
            details: {
              0: {
                lbl: 'American Indian or Alaskan Native',
                key: 'americanIndianOrAlaskanNative1'
              },
              1: {
                lbl: 'this is a test',
                key: 'thisIsATest1'
              },
              options: [{
                lbl: 'test',
                key: 'test1'
              }, {
                lbl: 'this is a test',
                key: 'thisIsATest1'
              }, {
                lbl: 'and this is too',
                key: 'andThisIsToo1'
              }]
            }
          }, {
            type: 'Checkboxes',
            formKey: 'asian',
            label: 'Asian',
            details: {
              options: [{
                lbl: 'Asian Indian',
                key: 'asianIndian1'
              }, {
                lbl: 'Chinese',
                key: 'chinese1'
              }, {
                lbl: 'Filipino',
                key: 'filipino1'
              }, {
                lbl: 'Japanese',
                key: 'japanese1'
              }, {
                lbl: 'Korean',
                key: 'korean1'
              }, {
                lbl: 'Laotian',
                key: 'laotian1'
              }, {
                lbl: 'Other Asian',
                key: 'otherAsian1'
              }, {
                lbl: 'Thai',
                key: 'thai1'
              }, {
                lbl: 'Vietnamese',
                key: 'vietnamese1'
              }]
            }
          }, {
            type: 'Checkboxes',
            formKey: 'blackOrAfricanAmerican',
            label: 'Black or African American',
            details: {
              options: [{
                lbl: 'Black or African American',
                key: 'blackOrAfricanAmerican1'
              }]
            }
          }, {
            type: 'Checkboxes',
            formKey: 'nativeHawaiinOrOtherPacificIslander',
            label: 'Native Hawaiin or Other Pacific Islander',
            details: {
              options: [{
                lbl: 'Guamanian or Chamorro',
                key: 'guamanianOrChamorro1'
              }, {
                lbl: 'Micronesian',
                key: 'micronesian1'
              }, {
                lbl: 'Native Hawaiian or Part-Hawn',
                key: 'nativeHawaiianOrPartHawn1'
              }, {
                lbl: 'Other Pacific Islander',
                key: 'otherPacificIslander1'
              }, {
                lbl: 'Samoan',
                key: 'samoan1'
              }, {
                lbl: 'Tongan',
                key: 'tongan1'
              }]
            }
          }]
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Hr',
          children: []
        }, {
          type: 'Row',
          children: [{
            type: 'Spacer',
            children: [],
            desc: '',
            label: 'Birth Date'
          }, {
            type: 'Dropdown',
            formKey: 'month',
            label: 'Month'
          }, {
            type: 'Dropdown',
            formKey: 'day',
            label: 'Day'
          }, {
            type: 'Dropdown',
            formKey: 'year',
            label: 'Year'
          }]
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Row',
          children: [{
            type: 'Text',
            formKey: 'birthplaceStateOrForeignCountry',
            label: 'Birthplace (State or Foreign Country)'
          }, {
            type: 'Dropdown',
            formKey: 'wereAnyOfYourAncestorsHawaiian',
            label: 'Were any of your ancestors Hawaiian?',
            details: {
              options: [{
                lbl: 'No',
                key: 'no1'
              }, {
                lbl: 'Yes',
                key: 'yes1'
              }]
            }
          }, {
            type: 'Radios',
            formKey: 'areYouTheFirstInYourImmediateFamilyToAttendCollege',
            label: 'Are you the first in your immediate family to attend college?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }]
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Hr',
          children: []
        }, {
          type: 'Row',
          children: [{
            type: 'Radios',
            formKey: 'areYouAMemberOfTheArmedForces',
            label: '1) Are you a member of the Armed Forces?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }, {
            type: 'Radios',
            formKey: 'areYouAMemberOfTheTheNationalGuardOrReserves',
            label: '2) Are you a member of the the National Guard or Reserves?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }, {
            type: 'Radios',
            formKey: 'areYouAVeteran',
            label: '3) Are you a Veteran?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }]
        }]
      }, {
        type: 'Column',
        children: [{
          type: 'Row',
          children: [{
            type: 'Radios',
            formKey: '4AreYouASpouseOf12Or3Above',
            label: '4) Are you a spouse of 1), 2) or 3) above?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }, {
            type: 'Radios',
            formKey: '5AreYouADependentOf12Or3Above',
            label: '5) Are you a dependent of 1), 2) or 3) above?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }, {
            type: 'Radios',
            formKey: '6DoYouIntendToUseYourGIBillBenefits',
            label: '6) Do you intend to use your G.I. Bill benefits?',
            details: {
              options: [{
                lbl: 'Yes',
                key: 'yes1'
              }, {
                lbl: 'No',
                key: 'no1'
              }]
            }
          }]
        }]
      }]
    }],
    label: 'Personal Information'
  }]
});