'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

exports.default = function () {
  var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

  var Formbot = {
    renderGadget: _gadgetRenderer2.default,
    buildHeadingParts: _gadgetRenderer.buildHeadingParts,
    renderConfigGadget: _gadgetRendererConfig2.default,
    renderEmptyForm: _gadgetRendererEmpty2.default,
    options: options
  };

  var context = Formbot.context = {
    progressiveDisclosures: [],
    decorators: [],
    gadgets: {},
    presets: {}
  };

  Formbot.registerGadget = function (key, gadgetDefinition) {
    if (context.gadgets[key]) {
      var msg = 'A gadget is already registered at key ' + key + '.';
      throw Error('DUPLICATE_GADGET_KEY: ' + msg);
    }
    gadgetDefinition.meta = _extends({
      icon: 'extension',
      category: 'Element'
    }, gadgetDefinition.meta || {});
    context.gadgets[key] = gadgetDefinition;
  };

  Formbot.unregisterGadget = function (key) {
    delete context.gadgets[key];
  };

  Formbot.registerPreset = function (key, type, lbl) {
    var data = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};
    var meta = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    if (context.presets[key]) {
      var msg = 'A preset is already registered at key ' + key + '.';
      throw Error('DUPLICATE_PRESET_KEY: ' + msg);
    }
    if (!context.gadgets[type]) {
      throw Error('GADGET_NOT_FOUND: There is no gadget registered as ' + type + '.');
    }
    context.presets[key] = {
      data: _extends({}, data, {
        formKey: key,
        type: type
      }),
      meta: _extends({
        icon: context.gadgets[type].meta.icon
      }, meta, {
        lbl: lbl
      })
    };
  };

  Formbot.middlewareTransformer = _lodash.identity;

  Formbot.getGadget = function (key) {
    return context.gadgets[key] || context.gadgets.NotFound;
  };

  Formbot.registerProgressiveDisclosure = function (progressiveDisclosure) {
    return context.progressiveDisclosures.push(progressiveDisclosure);
  };

  Formbot.getProgressiveDisclosures = function () {
    return [].concat(_toConsumableArray(context.progressiveDisclosures));
  };

  Formbot.registerDecorator = function (pattern, val) {
    return context.decorators.push({ pattern: pattern, val: val });
  };

  Formbot.getDecorators = function (_pattern) {
    var matching = (0, _lodash.filter)(context.decorators, function (_ref) {
      var pattern = _ref.pattern;

      for (var key in pattern) {
        if (!(key in _pattern) || _pattern[key] !== pattern[key]) return false;
      }
      return true;
    });
    return (0, _lodash.map)(matching, 'val');
  };

  Formbot.decorate = function (decorators, parts, props, gadgetDefinition, createComponent) {
    return (0, _lodash.reduce)(decorators, function (memo, dec) {
      var decorations = dec(props, gadgetDefinition);
      return (0, _lodash.mapValues)(memo, function (part, key) {
        return (decorations[key] || _lodash.identity)(part, createComponent);
      });
    }, parts);
  };

  Formbot.render = function (mode, template, trashed, data) {
    var props = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : {};

    var gadgetInstances = (0, _utils.gatherGadgetsComplex)(template, null, trashed);
    var toRender = props.multipageNum ? template.children[props.multipageNum - 1] : template;
    return (0, _renderer2.default)(Formbot, mode, toRender, data, gadgetInstances, props);
  };

  return Formbot;
};

var _lodash = require('lodash');

var _gadgetRenderer = require('./gadget-renderer');

var _gadgetRenderer2 = _interopRequireDefault(_gadgetRenderer);

var _gadgetRendererConfig = require('./gadget-renderer-config');

var _gadgetRendererConfig2 = _interopRequireDefault(_gadgetRendererConfig);

var _gadgetRendererEmpty = require('./gadget-renderer-empty');

var _gadgetRendererEmpty2 = _interopRequireDefault(_gadgetRendererEmpty);

var _renderer = require('./renderer');

var _renderer2 = _interopRequireDefault(_renderer);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }