'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _shortid = require('shortid');

var _shortid2 = _interopRequireDefault(_shortid);

var _keyedList = require('./keyed-list.css');

var _keyedList2 = _interopRequireDefault(_keyedList);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var KeyedList = function (_Component) {
  _inherits(KeyedList, _Component);

  function KeyedList() {
    _classCallCheck(this, KeyedList);

    return _possibleConstructorReturn(this, (KeyedList.__proto__ || Object.getPrototypeOf(KeyedList)).apply(this, arguments));
  }

  _createClass(KeyedList, [{
    key: 'addValue',
    value: function addValue(key, lbl) {
      var _props = this.props,
          value = _props.value,
          onChange = _props.onChange;

      var newValue = (0, _lodash.cloneDeep)(value);
      var singleVal = (0, _lodash.find)(newValue, { key: key });
      if (!singleVal) return;
      singleVal.lbl = lbl;
      onChange(newValue);
    }
  }, {
    key: 'addItem',
    value: function addItem() {
      var _props2 = this.props,
          value = _props2.value,
          onChange = _props2.onChange;

      var newValue = [].concat(_toConsumableArray(value), [{ key: _shortid2.default.generate(), lbl: '' }]);
      onChange(newValue);
    }
  }, {
    key: 'handleKeyDown',
    value: function handleKeyDown(e) {
      if (e.keyCode === 13) {
        e.preventDefault();
        this.addItem();
      }
    }
  }, {
    key: 'removeValue',
    value: function removeValue(i) {
      var _props3 = this.props,
          value = _props3.value,
          onChange = _props3.onChange;

      onChange([].concat(_toConsumableArray(value.slice(0, i)), _toConsumableArray(value.slice(i + 1, value.length))));
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var value = this.props.value;

      return _react2.default.createElement(
        'div',
        { className: _keyedList2.default['keyed-list'] },
        _react2.default.createElement(
          _kualiUi.Form,
          { showGrid: !!value.length },
          (0, _lodash.map)(value, function (_ref, i) {
            var key = _ref.key,
                lbl = _ref.lbl;
            return _react2.default.createElement(
              _kualiUi.FieldGroup,
              {
                key: 'keyed-list-row-' + key,
                className: _keyedList2.default['selection-option']
              },
              _react2.default.createElement(
                'div',
                { className: 'kuali-form__cell' },
                _react2.default.createElement(
                  _kualiUi.Label,
                  { htmlFor: key },
                  'Selection ' + (i + 1)
                ),
                _react2.default.createElement(_kualiUi.TextField, {
                  autoFocus: true,
                  id: key,
                  placeholder: 'Enter a value for this selection',
                  onChange: function onChange(val) {
                    return _this2.addValue(key, val);
                  },
                  onKeyDown: function onKeyDown(e) {
                    return _this2.handleKeyDown(e);
                  },
                  value: lbl
                })
              ),
              _react2.default.createElement(
                'div',
                { className: 'kuali-form__cell' },
                _react2.default.createElement(
                  _kualiUi.IconButton,
                  { onClick: function onClick() {
                      return _this2.removeValue(i);
                    } },
                  _react2.default.createElement(_kualiUi.Icon, { name: 'delete' })
                )
              )
            );
          })
        ),
        _react2.default.createElement(
          _kualiUi.FlatButton,
          {
            className: _keyedList2.default['add-item'],
            label: 'Add Item',
            onClick: function onClick() {
              return _this2.addItem();
            }
          },
          _react2.default.createElement(_kualiUi.Icon, { name: 'add' })
        )
      );
    }
  }]);

  return KeyedList;
}(_react.Component);

KeyedList.displayName = 'KeyedList';
KeyedList.propTypes = {
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.array.isRequired
};
exports.default = KeyedList;