'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sanitize = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                   * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                   * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                   *
                                                                                                                                                                                                                                                                   * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                   * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                   */

exports.gatherGadgetsById = gatherGadgetsById;
exports.gatherGadgetsComplex = gatherGadgetsComplex;
exports.gatherGadgetsByIdComplex = gatherGadgetsByIdComplex;
exports.getGadgetConfig = getGadgetConfig;
exports.getGadgetPD = getGadgetPD;
exports.getGadgetMeta = getGadgetMeta;
exports.getSettingsPanels = getSettingsPanels;
exports.findGadgetById = findGadgetById;
exports.findGadgetPathById = findGadgetPathById;
exports.findGadgetsInProgDiscFromList = findGadgetsInProgDiscFromList;
exports.recursiveFind = recursiveFind;

var _lodash = require('lodash');

var _sanitizeHtml = require('sanitize-html');

var _sanitizeHtml2 = _interopRequireDefault(_sanitizeHtml);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function gatherGadgetsById(tmpl, trashed) {
  var gadgets = {};
  if (tmpl.id) {
    gadgets[tmpl.id] = _extends({}, tmpl);
    if (tmpl.children) {
      (0, _lodash.each)(tmpl.children, function (child) {
        var moar = gatherGadgetsById(child);
        gadgets = _extends({}, gadgets, moar);
      });
    }
  }
  if (trashed) {
    (0, _lodash.each)(trashed, function (t) {
      gadgets[t.id] = t;
    });
  }
  return gadgets;
}

function gatherGadgetsComplex(tmpl, parent, trashed) {
  var gadgets = [];
  if (tmpl.id) gadgets.push(_extends({}, tmpl, { parent: parent }));
  if (tmpl.children) {
    (0, _lodash.each)(tmpl.children, function (child) {
      var moar = gatherGadgetsComplex(child, tmpl);
      gadgets = [].concat(_toConsumableArray(gadgets), _toConsumableArray(moar));
    });
  }
  if (trashed) gadgets = [].concat(_toConsumableArray(gadgets), _toConsumableArray(trashed));
  return gadgets;
}

function gatherGadgetsByIdComplex(tmpl, parent) {
  var gadgets = {};
  if (tmpl.id) gadgets[tmpl.id] = _extends({}, tmpl, { parent: parent });
  if (tmpl.children) {
    (0, _lodash.each)(tmpl.children, function (child) {
      var moar = gatherGadgetsByIdComplex(child, tmpl);
      gadgets = _extends({}, gadgets, moar);
    });
  }
  return gadgets;
}

function getGadgetConfig(Formbot, tmpl, id) {
  var gadget = findGadgetComplex(tmpl, id);
  var gadgetDefinition = Formbot.getGadget(gadget.type);
  return gadgetDefinition.config;
}

function getGadgetPD(Formbot, tmpl, id) {
  var gadget = findGadgetComplex(tmpl, id);
  var gadgetDefinition = Formbot.getGadget(gadget.type);
  return gadgetDefinition.progressiveDisclosure;
}

function getGadgetMeta(Formbot, tmpl, id) {
  var gadget = findGadgetComplex(tmpl, id);
  var gadgetDefinition = Formbot.getGadget(gadget.type);
  return gadgetDefinition.meta;
}

function getSettingsPanels(Formbot, GeneralSettings, tmpl, id) {
  var gadget = findGadgetComplex(tmpl, id);
  var gadgetDefinition = Formbot.getGadget(gadget.type);
  var panels = [{
    label: 'General',
    component: GeneralSettings
  }];
  if (gadgetDefinition.config) {
    panels.push({
      key: 'details',
      label: 'Specific',
      component: gadgetDefinition.config
    });
  }
  // panels.push(VALIDATIONS)
  if (gadget.parent && gadget.parent.type) {
    var parentGadgetDefinition = Formbot.getGadget(gadget.parent.type);
    if (parentGadgetDefinition && parentGadgetDefinition.childConfig) {
      panels.push({
        key: 'parentDetails',
        label: 'Layout',
        component: parentGadgetDefinition.childConfig
      });
    }
  }
  // panels.push(ROLES)
  return panels;
}

function findGadgetComplex(tmpl, id) {
  var gadgets = gatherGadgetsByIdComplex(tmpl);
  return gadgets[id];
}

function findGadgetById(tmpl, id) {
  var gadgets = gatherGadgetsById(tmpl);
  return gadgets[id];
}

function findGadgetPathById(tmpl, id) {
  var res = findGadgetPath(tmpl, id, []) || [];
  return res.join('.');
}

function findGadgetPath(tmpl, id, chunks) {
  if (tmpl.id === id) return chunks;
  if (tmpl.children) {
    var path = (0, _lodash.reduce)(tmpl.children, function (memo, child, i) {
      var newChunks = [].concat(_toConsumableArray(chunks), ['children', i]);
      var res = findGadgetPath(child, id, newChunks);
      return memo || res;
    }, null);
    if (path) return path;
  }
  return null;
}

function findGadgetsInProgDiscFromList(gadget, checkGadgetList) {
  var selfCheck = findDependentProgDiscGadgets(gadget, checkGadgetList);

  var children = gadget.children || [];

  var childrenChecks = (0, _lodash.flatten)((0, _lodash.concat)((0, _lodash.map)(children, function (child) {
    return findGadgetsInProgDiscFromList(child, checkGadgetList);
  })));

  return (0, _lodash.concat)(childrenChecks, selfCheck);
}

function findDependentProgDiscGadgets(targetGadget, gadgetList) {
  if (!targetGadget.formKey) return [];
  var items = (0, _lodash.filter)(gadgetList, function (instance) {
    return gadgetUsesFormKeyInProgDisc(instance, targetGadget.formKey);
  });
  return (0, _lodash.map)(items, function (item) {
    return {
      progDiscGadget: item,
      targetGadget: targetGadget
    };
  });
}

function gadgetUsesFormKeyInProgDisc(gadget, formKey) {
  if ((0, _lodash.isEmpty)(gadget.progressiveDisclosure)) return false;
  var parts = (0, _lodash.get)(gadget, 'progressiveDisclosure.parts', []);
  return !!(0, _lodash.find)(parts, { formKey: formKey });
}

var extendedAllowedAttributes = (0, _lodash.merge)({}, _sanitizeHtml2.default.defaults.allowedAttributes, {
  '*': ['style', 'class']
});

var extendedAllowedTags = _sanitizeHtml2.default.defaults.allowedTags.concat(['span', 's', 'u']);

var sanitize = exports.sanitize = (0, _lodash.partialRight)(_sanitizeHtml2.default, {
  allowedAttributes: extendedAllowedAttributes,
  allowedTags: extendedAllowedTags
});

function recursiveFind(gadgets, matchPattern) {
  var isMatch = (0, _lodash.matches)(matchPattern);
  var _iteratorNormalCompletion = true;
  var _didIteratorError = false;
  var _iteratorError = undefined;

  try {
    for (var _iterator = gadgets[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
      var gadget = _step.value;

      if (isMatch(gadget)) {
        return gadget;
      } else if (gadget.children) {
        var childResult = recursiveFind(gadget.children, matchPattern);
        if (childResult) {
          return childResult;
        }
      }
    }
  } catch (err) {
    _didIteratorError = true;
    _iteratorError = err;
  } finally {
    try {
      if (!_iteratorNormalCompletion && _iterator.return) {
        _iterator.return();
      }
    } finally {
      if (_didIteratorError) {
        throw _iteratorError;
      }
    }
  }
}