/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import { mount } from 'enzyme'
import createFormbot from '../index'
import * as basicGadgets from '../../gadgets-basic'
import * as coreGadgets from '../../gadgets-core'
import * as formGadgets from '../../gadgets-forms'
import * as layoutGadgets from '../../gadgets-layout'
import * as utils from '../utils'
import exampleForm from './__fixtures__/example-form'

describe('lib/utils', () => {
  describe('gatherGadgetsById', () => {
    it('should gather gadgets by id', () => {
      const gadgets = utils.gatherGadgetsById(exampleForm)
      expect(gadgets).toMatchSnapshot()
    })

    it('returns empty object if template does not have any gadgets', () => {
      const gadgets = utils.gatherGadgetsById({})
      expect(gadgets).toEqual({})
    })

    it('adds trash items to gadgets', () => {
      const template = {
        id: '0',
        type: 'Column',
        children: []
      }
      const trash = [
        {
          id: '1',
          type: 'Section'
        }
      ]
      const gadgets = utils.gatherGadgetsById(template, trash)
      expect(gadgets).toEqual({
        '0': {
          id: '0',
          type: 'Column',
          children: []
        },
        '1': {
          id: '1',
          type: 'Section'
        }
      })
    })
  })

  describe('gatherGadgetsComplex', () => {
    it('should gather gadgets', () => {
      const trash = [
        {
          id: '1',
          type: 'Section'
        }
      ]
      const gadgets = utils.gatherGadgetsComplex(exampleForm, null, trash)
      expect(gadgets).toMatchSnapshot()
    })

    it('returns empty array if template does not have any gadgets', () => {
      const gadgets = utils.gatherGadgetsComplex({})
      expect(gadgets).toEqual([])
    })
  })

  describe('gatherGadgetsByIdComplex', () => {
    it('should gather gadgets', () => {
      const trash = [
        {
          id: '1',
          type: 'Section'
        }
      ]
      const gadgets = utils.gatherGadgetsByIdComplex(exampleForm, null, trash)
      expect(gadgets).toMatchSnapshot()
    })

    it('returns empty array if template does not have any gadgets', () => {
      const gadgets = utils.gatherGadgetsByIdComplex({})
      expect(gadgets).toEqual({})
    })
  })

  describe('getGadgetConfig', () => {
    let Formbot
    beforeEach(() => {
      Formbot = createFormbot()
      const registerGadgets = gadgets => {
        Object.entries(gadgets).forEach(([key, gadget]) =>
          Formbot.registerGadget(key, gadget)
        )
      }
      registerGadgets(layoutGadgets)
      registerGadgets(basicGadgets)
      registerGadgets(formGadgets)
      registerGadgets(coreGadgets)
    })

    it('should get the gadget config', () => {
      const Config = utils.getGadgetConfig(Formbot, exampleForm, 'id-10')
      const props = {
        value: {
          placeholder: 'placeholder'
        },
        onChange: jest.fn()
      }
      mount(<Config {...props} />)
    })
  })
})
