'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _Checkbox = require('react-md/lib/SelectionControls/Checkbox');

var _Checkbox2 = _interopRequireDefault(_Checkbox);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                     * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                     * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                     *
                                                                                                                                                                                                     * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                     * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                     */

function CheckboxesEdit(_ref) {
  var id = _ref.id,
      _ref$value = _ref.value,
      value = _ref$value === undefined ? [] : _ref$value,
      details = _ref.details,
      _onChange = _ref.onChange;

  var correctedValue = (0, _utils.convertTruthyKeys)(value);
  var options = (0, _lodash.filter)(details.options, function (o) {
    return o.key;
  });
  return _react2.default.createElement(
    'div',
    null,
    (0, _lodash.map)(options, function (o) {
      return _react2.default.createElement(
        'div',
        { key: o.key },
        _react2.default.createElement(_Checkbox2.default, {
          id: '' + o.key + id,
          name: id,
          checked: (0, _lodash.includes)(correctedValue, o.key),
          onChange: function onChange(val) {
            return _onChange(val ? (0, _lodash.uniq)([].concat(_toConsumableArray(correctedValue), [o.key])) : (0, _lodash.without)(correctedValue, o.key));
          },
          label: o.lbl
        })
      );
    })
  );
}

exports.default = CheckboxesEdit;
CheckboxesEdit.displayName = 'CheckboxesEdit';

CheckboxesEdit.propTypes = {
  details: _propTypes2.default.shape({
    options: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      key: _propTypes2.default.string,
      lbl: _propTypes2.default.string
    }))
  }).isRequired,
  id: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.oneOfType([_propTypes2.default.object.isRequired, _propTypes2.default.array.isRequired])
};