'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                     * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                     * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                     *
                                                                                                                                                                                                     * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                     * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                     */

function DropdownEdit(_ref) {
  var details = _ref.details,
      formKey = _ref.formKey,
      _onChange = _ref.onChange,
      value = _ref.value;

  var options = (0, _lodash.filter)(details.options, 'key');
  return _react2.default.createElement(_kualiUi.SelectField, {
    id: formKey,
    onChange: function onChange(val) {
      return _onChange(val);
    },
    fullWidth: true,
    value: value,
    menuItems: [{ key: '', lbl: '- - -' }].concat(_toConsumableArray(options)),
    itemLabel: 'lbl',
    itemValue: 'key'
  });
}

exports.default = DropdownEdit;
DropdownEdit.displayName = 'DropdownEdit';

DropdownEdit.propTypes = {
  details: _propTypes2.default.shape({
    options: _propTypes2.default.arrayOf(_propTypes2.default.shape({
      key: _propTypes2.default.string,
      lbl: _propTypes2.default.string
    }))
  }).isRequired,
  formKey: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string.isRequired
};