'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _TextFields = require('react-md/lib/TextFields');

var _TextFields2 = _interopRequireDefault(_TextFields);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

function NumberEdit(_ref) {
  var id = _ref.id,
      details = _ref.details,
      _onChange = _ref.onChange,
      value = _ref.value,
      error = _ref.error;

  var placeholder = (0, _lodash.get)(details, 'placeholder', '');
  return _react2.default.createElement(_TextFields2.default, {
    id: id,
    type: 'number',
    error: !!error,
    errorText: error,
    onChange: function onChange(val) {
      return _onChange(val);
    },
    placeholder: placeholder,
    value: value
  });
}

exports.default = NumberEdit;
NumberEdit.displayName = 'NumberEdit';

NumberEdit.propTypes = {
  id: _propTypes2.default.string,
  details: _propTypes2.default.shape({
    placeholder: _propTypes2.default.string
  }).isRequired,
  error: _propTypes2.default.string,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.number.isRequired
};