'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _kualiUi = require('@kuali/kuali-ui');

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function RadiosEdit(_ref) {
  var details = _ref.details,
      id = _ref.id,
      _onChange = _ref.onChange,
      a11yDesc = _ref.a11yDesc,
      _ref$value = _ref.value,
      value = _ref$value === undefined ? '' : _ref$value;

  var options = (0, _lodash.filter)(details.options, function (o) {
    return o.key;
  });

  return _react2.default.createElement(_kualiUi.SelectionControlGroup, {
    id: id,
    name: id,
    label: a11yDesc,
    labelClassName: _style2.default.accessibility,
    type: 'radio',
    value: value,
    onChange: function onChange(val) {
      return _onChange(val);
    },
    controls: (0, _lodash.map)(options, function (o) {
      return {
        label: o.lbl,
        value: o.key
      };
    })
  });
} /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
   * You may use and modify this code under the terms of the Kuali, Inc.
   * Pre-Release License Agreement. You may not distribute it.
   *
   * You should have received a copy of the Kuali, Inc. Pre-Release License
   * Agreement with this file. If not, please write to license@kuali.co.
   */

exports.default = RadiosEdit;


RadiosEdit.displayName = 'RadiosEdit';

RadiosEdit.propTypes = {
  details: _propTypes2.default.object.isRequired,
  id: _propTypes2.default.string.isRequired,
  onChange: _propTypes2.default.func.isRequired,
  value: _propTypes2.default.string.isRequired
};