/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { filter, map, includes, uniq, without } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import Checkbox from 'react-md/lib/SelectionControls/Checkbox'
import { convertTruthyKeys } from './utils'

export default function CheckboxesEdit ({ id, value = [], details, onChange }) {
  const correctedValue = convertTruthyKeys(value)
  const options = filter(details.options, o => o.key)
  return (
    <div>
      {map(options, o => (
        <div key={o.key}>
          <Checkbox
            id={`${o.key}${id}`}
            name={id}
            checked={includes(correctedValue, o.key)}
            onChange={val =>
              onChange(
                val
                  ? uniq([...correctedValue, o.key])
                  : without(correctedValue, o.key)
              )
            }
            label={o.lbl}
          />
        </div>
      ))}
    </div>
  )
}

CheckboxesEdit.displayName = 'CheckboxesEdit'

CheckboxesEdit.propTypes = {
  details: PropTypes.shape({
    options: PropTypes.arrayOf(
      PropTypes.shape({
        key: PropTypes.string,
        lbl: PropTypes.string
      })
    )
  }).isRequired,
  id: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.oneOfType([
    PropTypes.object.isRequired,
    PropTypes.array.isRequired
  ])
}
