/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { includes } from 'lodash'
import React, { Component } from 'react'
import PropTypes from 'prop-types'
import { SelectField } from '@kuali/kuali-ui'
import TextField from 'react-md/lib/TextFields'
import { convertTruthyKeys } from './utils'

export function check (data = [], config) {
  const correctedData = convertTruthyKeys(data)
  switch (config.type) {
    case 'isChecked':
      return includes(correctedData, config.value)
    case 'isNotChecked':
      return !includes(correctedData, config.value)
    case 'numChecked':
      return correctedData.length >= config.value
    case 'numNotChecked':
      return correctedData.length < config.value
    default:
      return true
  }
}

export function configIsValid (configData) {
  return configData.type && configData.value
}

export class component extends Component {
  static displayName = 'ProgressiveDisclosure'

  static propTypes = {
    id: PropTypes.string.isRequired,
    details: PropTypes.object.isRequired,
    onChange: PropTypes.func.isRequired,
    value: PropTypes.object.isRequired
  }

  renderSuffix (type) {
    if (!type) return null
    const { details, onChange, value } = this.props
    if (includes(['isChecked', 'isNotChecked'], type)) {
      const options = details.options || []
      return (
        <div style={{ display: 'flex', flex: 2, width: 0 }}>
          <SelectField
            id={type}
            className='pg-suffix'
            onChange={newVal => onChange({ ...value, value: newVal })}
            style={{ flex: 1, margin: '0 10px' }}
            value={value.value || ''}
            menuItems={[{ key: '', lbl: '- - -' }, ...options]}
            itemLabel='lbl'
            itemValue='key'
          />
          <div style={{ flex: 1, margin: 'auto' }}>{' checked'}</div>
        </div>
      )
    }
    if (includes(['numChecked', 'numNotChecked'], type)) {
      return (
        <div style={{ display: 'flex', flex: 2, width: 0 }}>
          <TextField
            className='pg-suffix'
            onChange={val => onChange({ ...value, value: val })}
            style={{ flex: 1, margin: '0 10px' }}
            type='number'
            value={value.value}
          />
          <div style={{ flex: 2, margin: 'auto' }}>{' items checked'}</div>
        </div>
      )
    }
    return null
  }

  render () {
    const { id, onChange, value } = this.props
    return (
      <div style={{ display: 'flex', flex: 3 }}>
        <SelectField
          id={id}
          onChange={type => onChange({ ...value, type })}
          style={{ flex: 1 }}
          value={value.type || ''}
          menuItems={[
            { key: '', lbl: '- - -' },
            { key: 'isChecked', lbl: 'has' },
            { key: 'isNotChecked', lbl: 'does not have' },
            { key: 'numChecked', lbl: 'has at least' },
            { key: 'numNotChecked', lbl: 'has less than' }
          ]}
          itemLabel='lbl'
          itemValue='key'
        />
        {this.renderSuffix(value.type)}
      </div>
    )
  }
}
