/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { reduce } from 'lodash'

export function validateShape (v, gadget) {
  const { options } = gadget.details
  return v.oneOfType([
    v.arrayOf(v.oneOf(options.map(option => option.key))),
    v.shape(
      reduce(
        options,
        (memo, option) => ({
          ...memo,
          [option.key]: v.optional(v.bool())
        }),
        {}
      )
    )
  ])
}
