/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { filter, map, includes } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import { convertTruthyKeys } from './utils'

export default function CheckboxesView ({ value = [], details }) {
  const options = filter(details.options, o => o.key)
  const correctedValue = convertTruthyKeys(value)
  return (
    <div>
      {map(
        options,
        o =>
          includes(correctedValue, o.key) ? (
            <div key={o.key}>{o.lbl}</div>
          ) : null
      )}
    </div>
  )
}

CheckboxesView.displayName = 'CheckboxesView'

CheckboxesView.propTypes = {
  details: PropTypes.object.isRequired,
  value: PropTypes.oneOfType([
    PropTypes.object.isRequired,
    PropTypes.array.isRequired
  ])
}
