/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { get } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import DatePicker from 'react-md/lib/Pickers/DatePickerContainer'

export default function DateEdit({ details, formKey, onChange, value }) {
  const placeholder = get(details, 'placeholder', '')
  return (
    <DatePicker
      autoOk
      formatOptions={{ month: 'long', day: 'numeric', year: 'numeric' }}
      fullWidth
      id={formKey}
      label={placeholder}
      onChange={dateString => {
        /* IE 11 doesn't handle Unicode characters well and
           dateString contains invisible #8206s (left-to-right-mark) */
        const ansiDateString = dateString.replace(/[\u{0080}-\u{FFFF}]/gu, '')
        onChange(ansiDateString)
      }}
      portal
      value={value ? new Date(value) : null}
    />
  )
}

DateEdit.displayName = 'DateEdit'

DateEdit.propTypes = {
  details: PropTypes.shape({
    placeholder: PropTypes.string
  }).isRequired,
  formKey: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string
}
