/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { get } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import TextField from 'react-md/lib/TextFields'

export default function NumberEdit ({ id, details, onChange, value, error }) {
  const placeholder = get(details, 'placeholder', '')
  return (
    <TextField
      id={id}
      type='number'
      error={!!error}
      errorText={error}
      onChange={val => onChange(val)}
      placeholder={placeholder}
      value={value}
    />
  )
}

NumberEdit.displayName = 'NumberEdit'

NumberEdit.propTypes = {
  id: PropTypes.string,
  details: PropTypes.shape({
    placeholder: PropTypes.string
  }).isRequired,
  error: PropTypes.string,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.number.isRequired
}
