/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { filter, map } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import { SelectionControlGroup } from '@kuali/kuali-ui'
import styles from './style.css'

export default function RadiosEdit ({
  details,
  id,
  onChange,
  a11yDesc,
  value = ''
}) {
  const options = filter(details.options, o => o.key)

  return (
    <SelectionControlGroup
      id={id}
      name={id}
      label={a11yDesc}
      labelClassName={styles.accessibility}
      type='radio'
      value={value}
      onChange={val => onChange(val)}
      controls={map(options, o => ({
        label: o.lbl,
        value: o.key
      }))}
    />
  )
}

RadiosEdit.displayName = 'RadiosEdit'

RadiosEdit.propTypes = {
  details: PropTypes.object.isRequired,
  id: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string.isRequired
}
