/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { filter, find } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'

export default function RadiosView ({ details, value }) {
  const options = filter(details.options, o => o.key)
  const option = find(options, { key: value }) || {}
  return <div>{option.lbl}</div>
}

RadiosView.displayName = 'RadiosView'

RadiosView.propTypes = {
  details: PropTypes.object.isRequired,
  value: PropTypes.string.isRequired
}
