/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import PropTypes from 'prop-types'

import sanitize from './sanitize'
import styles from './styles.css'

let Quill
if (typeof document !== 'undefined') {
  Quill = require('react-quill')
}

const toolbarItems = [
  [{ font: [] }],
  [{ size: [] }],
  [{ align: [] }],
  ['bold', 'italic', 'strike', 'underline'],
  [{ color: [] }, { background: [] }],
  [{ list: 'ordered' }, { list: 'bullet' }],
  ['link']
]

const keyboard = {
  bindings: {
    tab: {
      key: 9,
      handler: () => true // allow normal tab key event propagation
    }
  }
}

export default function RichTextEdit ({ onChange, value = '' }) {
  return (
    <div className={styles.edit}>
      <Quill
        theme='snow'
        defaultValue={sanitize(value)}
        modules={{ toolbar: toolbarItems, keyboard }}
        onChange={val => onChange(val)}
      />
    </div>
  )
}

RichTextEdit.displayName = 'RichTextEdit'

RichTextEdit.propTypes = {
  details: PropTypes.object.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.string.isRequired
}
