/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { includes } from 'lodash'
import React from 'react'
import PropTypes from 'prop-types'
import { SelectField } from '@kuali/kuali-ui'
import TextField from 'react-md/lib/TextFields'

import styles from './style.css'

export function check (data, config) {
  switch (config.type) {
    case 'contains':
      return includes(data, config.value)
    case 'notContains':
      return !includes(data, config.value)
    default:
      return true
  }
}

export function configIsValid (configData) {
  return configData.type && configData.value
}

export function component ({ id, onChange, value }) {
  return (
    <div className={styles.progDisc}>
      <SelectField
        id={`${id}-select-field`}
        className={styles.select}
        onChange={type => onChange({ ...value, type })}
        value={value.type || ''}
        menuItems={[
          { value: '', label: '- - -' },
          { value: 'contains', label: 'Contains' },
          { value: 'notContains', label: 'Does not contain' }
        ]}
      />
      <TextField
        id={`${id}-text-field`}
        onChange={val => onChange({ ...value, value: val })}
        style={{ flex: 1 }}
        value={value.value || ''}
      />
    </div>
  )
}

component.displayName = 'ProgressiveDisclosure'

component.propTypes = {
  id: PropTypes.string.isRequired,
  onChange: PropTypes.func.isRequired,
  value: PropTypes.shape({
    value: PropTypes.string,
    type: PropTypes.string
  }).isRequired
}
