'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.customGadgetRenderer = customGadgetRenderer;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _Papers = require('react-md/lib/Papers');

var _Papers2 = _interopRequireDefault(_Papers);

var _viewEdit = require('./view-edit.css');

var _viewEdit2 = _interopRequireDefault(_viewEdit);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function customGadgetRenderer(Formbot, mode, template, options) {
  var children = options.children,
      shouldShow = options.shouldShow,
      context = options.context;

  if (!shouldShow) return null;
  var gadgetDef = Formbot.getGadget(template.type);
  var label = _react2.default.createElement(
    'div',
    { className: _viewEdit2.default.title },
    template.label
  );
  var decorators = Formbot.getDecorators({ type: template.type, mode: mode });
  var props = { children: children, context: context, template: template };
  var createComponent = function createComponent(_props) {
    var gadget = _react2.default.createElement(
      'div',
      { style: { padding: 15, display: 'flex', flexWrap: 'wrap' } },
      _props.children
    );
    var parts = decorators.length ? Formbot.decorate(decorators, { label: label, gadget: gadget }, _props, gadgetDef) : { label: label, gadget: gadget };
    var toRender = template.root ? _react2.default.createElement(
      'div',
      null,
      parts.gadget
    ) : _react2.default.createElement(
      'div',
      { className: _viewEdit2.default['size-' + (template.fieldSize || 'large')] },
      _react2.default.createElement(
        _Papers2.default,
        { className: _viewEdit2.default.wrapper, key: template.id },
        parts.label,
        parts.gadget
      )
    );

    return toRender;
  };
  var component = createComponent(props);
  return decorators.length ? Formbot.decorate(decorators, { component: component }, props, gadgetDef, createComponent).component : component;
} /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
   * You may use and modify this code under the terms of the Kuali, Inc.
   * Pre-Release License Agreement. You may not distribute it.
   *
   * You should have received a copy of the Kuali, Inc. Pre-Release License
   * Agreement with this file. If not, please write to license@kuali.co.
   */