/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React from 'react'
import PropTypes from 'prop-types'

const NOTFOUND_STYLE = {
  backgroundColor: '#F0AD4E',
  color: 'white',
  padding: 15,
  fontSize: 20,
  textAlign: 'center'
}

export default function NotFoundViewEdit ({ NOTFOUND_TYPE }) {
  const str = NOTFOUND_TYPE
    ? `Sorry! We could not find the gadget named: ${NOTFOUND_TYPE}.`
    : 'Sorry! We could not find this gadget.'
  return <div style={NOTFOUND_STYLE}>{str}</div>
}

NotFoundViewEdit.displayName = 'NotFoundViewEdit'

NotFoundViewEdit.propTypes = {
  NOTFOUND_TYPE: PropTypes.string
}
