/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import { get } from 'lodash'
import React from 'react'
import styles from './view-edit.css'

export function customGadgetRenderer (Formbot, mode, template, options) {
  const { children, childrenTemplates, shouldShow, onChange, value } = options
  if (!shouldShow) return null
  const gadgetDef = Formbot.getGadget(template.type)
  const Gadget = gadgetDef[mode]
  const gadgetChildren = React.Children.map(children, (c, i) => {
    const tmpl = childrenTemplates[i]
    const style = get(tmpl, 'parentDetails.flex')
      ? { flex: get(tmpl, 'parentDetails.flex') }
      : {}
    return (
      <div className={styles.gadgetRowContainer} style={style}>
        {c}
      </div>
    )
  })
  const props = {
    context: options.context,
    id: template.id,
    value,
    onChange,
    template
  }
  const decorators = Formbot.getDecorators({ type: template.type, mode })
  const createComponent = _props => {
    const parts = decorators.length
      ? Formbot.decorate(decorators, { gadgetChildren }, _props, gadgetDef)
      : { gadgetChildren }
    return (
      <div key={template.id} className={styles.TEST}>
        <Gadget value={value} onChange={onChange} template={template}>
          {parts.gadgetChildren}
        </Gadget>
      </div>
    )
  }
  const component = createComponent(props)
  return decorators.length
    ? Formbot.decorate(
        decorators,
        { component },
        props,
        gadgetDef,
        createComponent
      ).component
    : component
}
