/* Copyright © 2016 Kuali, Inc. - All Rights Reserved
 * You may use and modify this code under the terms of the Kuali, Inc.
 * Pre-Release License Agreement. You may not distribute it.
 *
 * You should have received a copy of the Kuali, Inc. Pre-Release License
 * Agreement with this file. If not, please write to license@kuali.co.
 */

import React, { Component } from 'react'
import PropTypes from 'prop-types'

import styles from './view-edit.css'

export default class RowViewEdit extends Component {
  static displayName = 'RowViewEdit'

  static propTypes = {
    children: PropTypes.array.isRequired
  }

  render () {
    const { children } = this.props
    if (children && children.length === 0) return null
    return <div className={styles.TEST_AGAIN}>{children}</div>
  }
}
