const chalk = require('chalk')
const commander = require('commander')
const pkg = require('../package.json')
const nodeVersion = require('node-version')

if (nodeVersion.major < 6) {
  const err = chalk.red('Error!')
  console.error(
    '> ' + err + ' build-helper requires >= Node v7. Please upgrade!'
  )
  process.exit(1)
}

commander
  .version(pkg.version)
  .command('publish', 'publish a new version of an npm module', {
    isDefault: true
  })

// Hack for commander bug: https://github.com/tj/commander.js/issues/335
process.argv[1] = __filename

commander.parse(process.argv)
