const config = require('./config')
const inquirer = require('inquirer')
const open = require('open')
const pkg = require('../../package.json')
const { red } = require('chalk')
const CircleCI = require('circleci')

const getApiToken = async function () {
  if (!config.has('circleci.token')) {
    open('https://circleci.com/account/api')

    const question = {
      type: 'input',
      name: 'token',
      message: 'Generate a new CircleCI Personal API Token and enter here:'
    }

    const answer = await inquirer.prompt(question)
    config.set('circleci.token', answer.token)

    if (!config.has('circleci.token')) {
      console.error(
        red(`Missing CircleCI API token in ~/.config/${pkg.name}/config.json`)
      )
      process.exit(1)
    }
  }
  return config.get('circleci.token')
}

exports.getAuthenticatedClient = async function () {
  return new CircleCI({ auth: await getApiToken() })
}
