'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _TextFields = require('react-md/lib/TextFields');

var _TextFields2 = _interopRequireDefault(_TextFields);

var _FontIcons = require('react-md/lib/FontIcons');

var _FontIcons2 = _interopRequireDefault(_FontIcons);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var ColumnMenuColumnHeader = function (_Component) {
  _inherits(ColumnMenuColumnHeader, _Component);

  function ColumnMenuColumnHeader() {
    _classCallCheck(this, ColumnMenuColumnHeader);

    return _possibleConstructorReturn(this, (ColumnMenuColumnHeader.__proto__ || Object.getPrototypeOf(ColumnMenuColumnHeader)).apply(this, arguments));
  }

  _createClass(ColumnMenuColumnHeader, [{
    key: 'getStyles',
    value: function getStyles() {
      var _props = this.props,
          iconStyle = _props.iconStyle,
          textfieldStyle = _props.textfieldStyle;


      var defaultStyle = {
        icon: {
          left: '-50px',
          position: 'absolute',
          top: '10px'
        },
        textfield: {
          position: 'absolute',
          top: '-3px',
          left: '13px',
          width: '160px'
        }
      };

      var icon = defaultStyle.icon,
          textfield = defaultStyle.textfield;

      return {
        icon: Object.assign(icon, iconStyle),
        textfield: Object.assign(textfield, textfieldStyle)
      };
    }
  }, {
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          filter = _props2.filter,
          filterText = _props2.filterText,
          name = _props2.name,
          onChange = _props2.onChange;

      var _getStyles = this.getStyles(),
          icon = _getStyles.icon,
          textfield = _getStyles.textfield;

      return _react2.default.createElement(
        'div',
        { className: _style2.default.hdr },
        filter ? _react2.default.createElement(_TextFields2.default, {
          key: 'cmc-filter-field',
          id: 'cmc-filter-field',
          placeholder: 'Filter',
          rightIcon: _react2.default.createElement(
            _FontIcons2.default,
            { style: icon },
            'action_search'
          ),
          value: filterText,
          onChange: onChange,
          fullWidth: false,
          style: textfield
        }) : _react2.default.createElement(
          'span',
          null,
          name || ''
        )
      );
    }
  }]);

  return ColumnMenuColumnHeader;
}(_react.Component);

ColumnMenuColumnHeader.propTypes = {
  filter: _propTypes2.default.bool,
  filterText: _propTypes2.default.string,
  iconStyle: _propTypes2.default.object,
  name: _propTypes2.default.string,
  onChange: _propTypes2.default.func,
  textfieldStyle: _propTypes2.default.object
};
exports.default = ColumnMenuColumnHeader;