'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _lodash = require('lodash');

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _ListItem = require('react-md/lib/Lists/ListItem');

var _ListItem2 = _interopRequireDefault(_ListItem);

var _Menu = require('react-md/lib/Menus/Menu');

var _Menu2 = _interopRequireDefault(_Menu);

var _cmColumnHdr = require('./cm-column-hdr');

var _cmColumnHdr2 = _interopRequireDefault(_cmColumnHdr);

var _style = require('./style.css');

var _style2 = _interopRequireDefault(_style);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _asyncToGenerator(fn) { return function () { var gen = fn.apply(this, arguments); return new Promise(function (resolve, reject) { function step(key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { return Promise.resolve(value).then(function (value) { step("next", value); }, function (err) { step("throw", err); }); } } return step("next"); }); }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */


var ColumnMenuColumn = function (_Component) {
  _inherits(ColumnMenuColumn, _Component);

  function ColumnMenuColumn(props) {
    _classCallCheck(this, ColumnMenuColumn);

    var _this = _possibleConstructorReturn(this, (ColumnMenuColumn.__proto__ || Object.getPrototypeOf(ColumnMenuColumn)).call(this, props));

    _this.state = {
      meta: undefined,
      items: undefined,
      filter: '',
      cacheKey: '',
      selected: undefined
    };

    _this.getStyles = _this.getStyles.bind(_this);
    _this.onSelect = _this.onSelect.bind(_this);
    _this.filterChangeHandler = _this.filterChangeHandler.bind(_this);
    return _this;
  }

  _createClass(ColumnMenuColumn, [{
    key: 'componentWillMount',
    value: function componentWillMount() {
      this.getItems(this.props);
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      if (this.shouldInitData(this.props, nextProps)) {
        this.getItems(nextProps);
      }
    }
  }, {
    key: 'shouldComponentUpdate',
    value: function shouldComponentUpdate(nextProps, nextState) {
      return !(0, _lodash.isEqual)(this.state, nextState) || !(0, _lodash.isEqual)(this.props, nextProps);
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      this.getItems();
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'getStyles',
    value: function getStyles() {
      var style = this.props.style;

      var menu = {
        overflowY: 'auto',
        width: 180,
        height: 352
      };
      return { menu: Object.assign(menu, style) };
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'shouldInitData',
    value: function shouldInitData(lastProps, nextProps) {
      if (nextProps.data === lastProps.data) {
        return false;
      }
      return !(0, _lodash.isEqual)(lastProps.data, nextProps.data);
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'getItems',
    value: function () {
      var _ref = _asyncToGenerator( /*#__PURE__*/regeneratorRuntime.mark(function _callee() {
        var _state, cacheKey, filterText, lastItems, filter, _props, data, isFiltered, items, meta, filterParam, resp, metas;

        return regeneratorRuntime.wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _state = this.state, cacheKey = _state.cacheKey, filterText = _state.filter, lastItems = _state.items;
                filter = filterText.length >= 3 ? filterText : '';

                if (!(lastItems && filter === cacheKey)) {
                  _context.next = 4;
                  break;
                }

                return _context.abrupt('return');

              case 4:
                _props = this.props, data = _props.data, isFiltered = _props.filter;
                items = void 0;
                meta = void 0;

                if (!(0, _lodash.isArray)(data)) {
                  _context.next = 12;
                  break;
                }

                items = isFiltered ? this.getFilteredArrayItems(data, filter) : data;
                meta = {};
                _context.next = 28;
                break;

              case 12:
                if (!(0, _lodash.isFunction)(data)) {
                  _context.next = 21;
                  break;
                }

                filterParam = isFiltered ? filter : undefined;
                _context.next = 16;
                return this.getFunctionItems(data, filterParam);

              case 16:
                resp = _context.sent;

                items = resp.items;
                meta = resp.meta;
                _context.next = 28;
                break;

              case 21:
                if (!(0, _lodash.isObject)(data)) {
                  _context.next = 27;
                  break;
                }

                items = this.getFilteredObjectItems(data, isFiltered ? filter : null);
                metas = ['_id', '_name', '_version', '_type', '_meta', '_icon'];

                meta = (0, _lodash.mapKeys)((0, _lodash.pick)(data, metas), function (v, k) {
                  return k.substr(1);
                });
                _context.next = 28;
                break;

              case 27:
                throw new Error('Unexpected data type');

              case 28:

                this.setState({ meta: meta, items: items, cacheKey: filter });

              case 29:
              case 'end':
                return _context.stop();
            }
          }
        }, _callee, this);
      }));

      function getItems() {
        return _ref.apply(this, arguments);
      }

      return getItems;
    }()
  }, {
    key: 'getFilteredArrayItems',
    value: function getFilteredArrayItems(data, filter) {
      return (0, _lodash.filter)(data, function (item) {
        return item.toString().includes(filter);
      });
    }
  }, {
    key: 'getFilteredObjectItems',
    value: function getFilteredObjectItems(data, filter) {
      return (0, _lodash.filter)(data, function (value, key) {
        var keyStr = key.toString();
        if (key[0] === '_') {
          return false;
        }
        return filter ? keyStr.includes(filter) : true;
      });
    }
  }, {
    key: 'getFunctionItems',
    value: function getFunctionItems(dataFn, filter) {
      return new Promise(function (resolve) {
        dataFn(filter, function (meta, items) {
          resolve({ meta: meta, items: items });
        });
      });
    }

    /**
     * NOTE: Expect this to be overridden
     * Called when the item is selected.
     */

  }, {
    key: 'getItem',
    value: function getItem(index) {
      var items = this.state.items;

      return items[index];
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'isLeaf',
    value: function isLeaf() {}

    /**
     * NOTE: Expect this to be overridden
     * NOTE: Not yet implemented
     */

  }, {
    key: 'isType',
    value: function isType(type) {
      return !type;
    }

    /**
     * NOTE: Expect this to be overridden
     * NOTE: Not yet implemented
     */

  }, {
    key: 'containsType',
    value: function containsType(type) {
      return !!type;
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'addColumn',
    value: function addColumn(key, value) {
      var column = value.config && value.config.prototype && value.config.prototype instanceof _react.Component ? value.config : ColumnMenuColumn;
      this.props.addColumn(column, key, value);
    }
  }, {
    key: 'noop',
    value: function noop() {}

    // --- Change Handlers ------------------------------------------------------

  }, {
    key: 'filterChangeHandler',
    value: function filterChangeHandler(filter) {
      this.setState({ filter: filter });
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'onSelect',
    value: function onSelect(event, key) {
      var value = this.getItem(key);
      this.setState({ selected: value });

      var match = this.props.onSelect(value);
      var leaf = value._cmc && value._cmc.leaf !== undefined ? value._cmc.leaf : this.isLeaf();

      if (leaf === false || leaf === undefined && !match) {
        this.addColumn(key, value);
      }
    }

    /**
     * NOTE: Expect this to be overridden
     */

  }, {
    key: 'renderColumnMenuItem',
    value: function renderColumnMenuItem(item, key, selected, MenuItem) {
      var _this2 = this;

      var label = (0, _lodash.isString)(key) ? key : item.name || item._name || item.toString();

      var active = item === selected;
      return _react2.default.createElement(MenuItem, {
        key: key,
        value: key,
        'data-test': 'cm-item-' + label,
        primaryText: label,
        active: active,
        className: active ? 'column-menu-item--active' : 'column-menu-item',
        leftIcon: (0, _lodash.get)(item, '_cmci.leftIcon'),
        style: (0, _lodash.get)(item, '_cmci.style'),
        onClick: function onClick(e) {
          return _this2.onSelect(e, key);
        }
      });
    }

    /**
     * Renders the Column.
     */

  }, {
    key: 'render',
    value: function render() {
      var _this3 = this;

      var filterChangeHandler = this.filterChangeHandler,
          noop = this.noop,
          props = this.props,
          state = this.state;
      var listItem = props.listItem,
          filter = props.filter;
      var _state$meta = state.meta,
          meta = _state$meta === undefined ? { name: '' } : _state$meta,
          items = state.items,
          filterText = state.filter,
          selected = state.selected;


      var ColMenuItem = listItem || _ListItem2.default;

      return _react2.default.createElement(
        'div',
        { className: _style2.default.col },
        _react2.default.createElement(_cmColumnHdr2.default, {
          filter: filter,
          filterText: filterText,
          name: meta.name,
          onChange: filterChangeHandler
        }),
        _react2.default.createElement(
          _Menu2.default,
          {
            isOpen: true,
            fullWidth: true,
            className: 'column-menu-menu',
            listClassName: 'column-menu-list',
            onClose: noop
          },
          (0, _lodash.map)(items, function (item, key) {
            return _this3.renderColumnMenuItem(item, key, selected, ColMenuItem);
          })
        )
      );
    }
  }]);

  return ColumnMenuColumn;
}(_react.Component);

ColumnMenuColumn.displayName = 'ColumnMenuColumn';
ColumnMenuColumn.defaultProps = {
  filter: false,
  cache: true
};
ColumnMenuColumn.propTypes = {
  addColumn: _propTypes2.default.func.isRequired,
  data: _propTypes2.default.oneOfType([_propTypes2.default.array, _propTypes2.default.object, _propTypes2.default.func]).isRequired,
  filter: _propTypes2.default.bool,
  headerIconStyle: _propTypes2.default.object,
  headerTextfieldStyle: _propTypes2.default.object,
  listItem: _propTypes2.default.instanceOf(_ListItem2.default),
  match: _propTypes2.default.oneOfType([_propTypes2.default.array, _propTypes2.default.func, _propTypes2.default.object, _propTypes2.default.string]).isRequired,
  onSelect: _propTypes2.default.func.isRequired,
  style: _propTypes2.default.object
};
exports.default = ColumnMenuColumn;