'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = undefined;

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames = require('classnames');

var _classnames2 = _interopRequireDefault(_classnames);

var _Dialogs = require('react-md/lib/Dialogs');

var _Dialogs2 = _interopRequireDefault(_Dialogs);

var _buttons = require('../buttons');

var _icons = require('../icons');

var _icons2 = _interopRequireDefault(_icons);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } /* Copyright © 2016 Kuali, Inc. - All Rights Reserved
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You may use and modify this code under the terms of the Kuali, Inc.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Pre-Release License Agreement. You may not distribute it.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                *
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * You should have received a copy of the Kuali, Inc. Pre-Release License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                * Agreement with this file. If not, please write to license@kuali.co.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                */

var DialogInner = function (_PureComponent) {
  _inherits(DialogInner, _PureComponent);

  function DialogInner() {
    _classCallCheck(this, DialogInner);

    return _possibleConstructorReturn(this, (DialogInner.__proto__ || Object.getPrototypeOf(DialogInner)).apply(this, arguments));
  }

  _createClass(DialogInner, [{
    key: 'render',
    value: function render() {
      var _props = this.props,
          children = _props.children,
          rest = _objectWithoutProperties(_props, ['children']);

      return _react2.default.createElement(
        'div',
        rest,
        _react2.default.createElement(
          'div',
          { className: 'kuali-dialog-inner' },
          children
        )
      );
    }
  }]);

  return DialogInner;
}(_react.PureComponent);

DialogInner.propTypes = {
  children: _propTypes2.default.node.isRequired
};

var Dialog = function (_Component) {
  _inherits(Dialog, _Component);

  function Dialog() {
    _classCallCheck(this, Dialog);

    return _possibleConstructorReturn(this, (Dialog.__proto__ || Object.getPrototypeOf(Dialog)).apply(this, arguments));
  }

  _createClass(Dialog, [{
    key: 'render',
    value: function render() {
      var _props2 = this.props,
          actions = _props2.actions,
          actionsPosition = _props2.actionsPosition,
          children = _props2.children,
          contentClassName = _props2.contentClassName,
          dialogClassName = _props2.dialogClassName,
          title = _props2.title,
          showClose = _props2.showClose,
          showHeader = _props2.showHeader,
          showFooter = _props2.showFooter,
          passThroughProps = _objectWithoutProperties(_props2, ['actions', 'actionsPosition', 'children', 'contentClassName', 'dialogClassName', 'title', 'showClose', 'showHeader', 'showFooter']);

      var contentClasses = (0, _classnames2.default)('kuali-dialog-section', contentClassName);

      var actionsAreRightAligned = actionsPosition === 'right';
      var actionsAreLeftAligned = actionsPosition === 'left';
      var actionsAreCenterAligned = !actionsAreRightAligned || !actionsAreLeftAligned;

      var dialogClasses = (0, _classnames2.default)('kuali-dialog', {
        'kuali-dialog--actions-right': actionsAreRightAligned,
        'kuali-dialog--actions-left': actionsAreLeftAligned,
        'kuali-dialog--actions-center': actionsAreCenterAligned
      }, dialogClassName);

      var stringTitle = typeof title === 'string' ? title : null;
      var describedby = this.props['aria-describedby'] || stringTitle;

      return _react2.default.createElement(
        _Dialogs2.default,
        _extends({
          actions: showFooter ? actions : null,
          'aria-describedby': describedby,
          component: DialogInner,
          contentClassName: contentClasses,
          dialogClassName: dialogClasses,
          focusOnMount: false,
          lastChild: true
        }, passThroughProps),
        showHeader && _react2.default.createElement(
          'header',
          { className: 'kuali-dialog--header' },
          _react2.default.createElement(
            'h1',
            { className: 'kuali-dialog--header---title' },
            title
          ),
          showClose && _react2.default.createElement(
            'div',
            { className: 'kuali-dialog--header---close' },
            _react2.default.createElement(
              _buttons.IconButton,
              { onClick: this.props.onHide },
              _react2.default.createElement(_icons2.default, { name: 'close' })
            )
          )
        ),
        _react2.default.createElement(
          'div',
          { className: 'kuali-dialog--content' },
          children
        )
      );
    }
  }]);

  return Dialog;
}(_react.Component);

Dialog.defaultProps = {
  actionsPosition: 'center',
  dialogClassName: '',
  contentClassName: '',
  showClose: true,
  showHeader: true,
  showFooter: true
};
Dialog.propTypes = {
  actions: _propTypes2.default.any,
  actionsPosition: _propTypes2.default.string,
  'aria-describedby': _propTypes2.default.string,
  dialogClassName: _propTypes2.default.string,
  children: _propTypes2.default.node.isRequired,
  contentClassName: _propTypes2.default.string,
  focusOnMount: _propTypes2.default.bool,
  lastChild: _propTypes2.default.bool,
  onHide: _propTypes2.default.func,
  showClose: _propTypes2.default.bool,
  showHeader: _propTypes2.default.bool,
  showFooter: _propTypes2.default.bool,
  title: _propTypes2.default.oneOfType([_propTypes2.default.string, _propTypes2.default.object])
};
exports.default = Dialog;